/*
 * Decompiled with CFR 0.152.
 */
package br.com.tempest.sentinelapi;

import br.com.tempest.sentinelapi.Capabilities;
import br.com.tempest.sentinelapi.Device;
import br.com.tempest.sentinelapi.HttpService;
import br.com.tempest.sentinelapi.InfraException;
import br.com.tempest.sentinelapi.Process;
import br.com.tempest.sentinelapi.User;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private ObjectMapper mapper;
    private HttpService httpService;

    public Context(HttpService httpService) {
        this.httpService = httpService;
        this.mapper = new ObjectMapper();
    }

    public Context(String key, String secret) {
        this(new HttpService(key, secret));
    }

    public User createUser(String name, String username, List<Device> devices) {
        User user = new User(name, username, devices);
        return this.deserialize(this.httpService.post("api/v2/users", user), User.class);
    }

    public User findUser(String username) {
        return this.deserialize(this.httpService.get("api/v2/users/" + username), User.class);
    }

    public User updateUser(User user) {
        return this.deserialize(this.httpService.post("api/v2/users/" + user.getUsername(), user), User.class);
    }

    public User updateUser(User user, boolean keepOtpDevices) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", user.getUsername());
        params.put("name", user.getName());
        params.put("devices", user.getDevices());
        params.put("keep_otp_devices", keepOtpDevices);
        return this.deserialize(this.httpService.post("api/v2/users/" + user.getUsername(), params), User.class);
    }

    public Device createDevice(String username, String number, Capabilities[] capabilities) {
        Device device = new Device();
        device.setNumber(number);
        device.setCapabilities(capabilities);
        return this.deserialize(this.httpService.post("api/v2/users/" + username + "/devices", device), Device.class);
    }

    public Device findDevice(String username, int deviceId) {
        return this.deserialize(this.httpService.get("api/v2/users/" + username + "/devices/" + deviceId), Device.class);
    }

    public Device updateDevice(String username, Device device) {
        return this.deserialize(this.httpService.put("api/v2/users/" + username + "/devices/" + device.getId(), device), Device.class);
    }

    public User deleteDevice(String username, int deviceId) {
        return this.deserialize(this.httpService.delete("api/v2/users/" + username + "/devices/" + deviceId), User.class);
    }

    public Device confirmDevice(String username, String token, String code, int deviceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        params.put("code", code);
        return this.deserialize(this.httpService.post("api/v2/users/" + username + "/devices/" + deviceId + "/confirm", params), Device.class);
    }

    public Process createProcess(String username, boolean enrollment) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", username);
        params.put("enrollment", enrollment);
        return this.deserialize(this.httpService.post("api/v2/process", params), Process.class);
    }

    public Process createProcess(String username) {
        return this.createProcess(username, false);
    }

    public Process findProcess(String token) {
        return this.deserialize(this.httpService.get("api/v2/process/" + token), Process.class);
    }

    public Process sendPasscode(String token, int deviceId, String username, Capabilities capabilitie) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("device_id", Integer.toString(deviceId));
        params.put("capability", capabilitie.toString());
        params.put("username", username);
        return this.deserialize(this.httpService.post("api/v2/process/" + token + "/send_passcode", params), Process.class);
    }

    public Process auth(String token, String username, String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        params.put("code", code);
        return this.deserialize(this.httpService.post("api/v2/process/" + token + "/auth", params), Process.class);
    }

    private <A> A deserialize(String json, Class<A> clazz) {
        try {
            return (A)this.mapper.readValue(json, clazz);
        }
        catch (JsonGenerationException e) {
            throw new InfraException(e.toString());
        }
        catch (JsonMappingException e) {
            throw new InfraException(e.toString());
        }
        catch (IOException e) {
            throw new InfraException(e.toString());
        }
    }
}

