/*
 * Decompiled with CFR 0.152.
 */
package br.com.tattobr.android.dialogs;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import br.com.tattobr.android.dialogs.R;
import com.google.android.material.textfield.TextInputLayout;

public class EditTextAlertDialogFragment
extends DialogFragment {
    private static final String TAG = "tag";
    private static final String TITLE = "title";
    private static final String MESSAGE = "message";
    private static final String TEXT = "text";
    private static final String INPUT_TYPE = "input_type";
    private static final String PARAMS = "params";

    public static EditTextAlertDialogFragment newInstance(int tag, int title, int message, String text) {
        return EditTextAlertDialogFragment.newInstance(tag, title, message, text, -1, null);
    }

    public static EditTextAlertDialogFragment newInstance(int tag, int title, int message, String text, int inputType, Bundle params) {
        EditTextAlertDialogFragment frag = new EditTextAlertDialogFragment();
        Bundle args = new Bundle();
        args.putInt(TAG, tag);
        args.putInt(TITLE, title);
        args.putInt(MESSAGE, message);
        args.putString(TEXT, text);
        args.putInt(INPUT_TYPE, inputType);
        args.putBundle(PARAMS, params);
        frag.setArguments(args);
        return frag;
    }

    public AlertDialog onCreateDialog(Bundle savedInstanceState) {
        int title;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        Bundle args = this.getArguments();
        View view = this.getActivity().getLayoutInflater().inflate(R.layout.dialog_edit_text, null);
        final EditText editText = (EditText)view.findViewById(16908308);
        TextInputLayout textInputLayout = (TextInputLayout)view.findViewById(R.id.hint);
        final int tag = args.getInt(TAG);
        final Bundle params = args.getBundle(PARAMS);
        textInputLayout.setHint((CharSequence)this.getString(args.getInt(MESSAGE)));
        editText.setText((CharSequence)args.getString(TEXT));
        int inputType = args.getInt(INPUT_TYPE);
        if (inputType >= 0) {
            editText.setRawInputType(inputType);
        }
        if ((title = args.getInt(TITLE)) != 0) {
            builder.setTitle(title);
        }
        builder.setView(view);
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                if (EditTextAlertDialogFragment.this.getActivity() instanceof EditTextAlertDialogFragmentListener) {
                    ((EditTextAlertDialogFragmentListener)EditTextAlertDialogFragment.this.getActivity()).onEditTextDialogPositiveButton(tag, editText.getText().toString(), params);
                }
            }
        });
        builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                if (EditTextAlertDialogFragment.this.getActivity() instanceof EditTextAlertDialogFragmentListener) {
                    ((EditTextAlertDialogFragmentListener)EditTextAlertDialogFragment.this.getActivity()).onEditTextDialogNegativeButton(tag, params);
                }
            }
        });
        return builder.create();
    }

    public static interface EditTextAlertDialogFragmentListener {
        public void onEditTextDialogPositiveButton(int var1, String var2, Bundle var3);

        public void onEditTextDialogNegativeButton(int var1, Bundle var2);
    }
}

