/*
 * Decompiled with CFR 0.152.
 */
package br.com.tattobr.android.adsanalytics;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.firebase.analytics.FirebaseAnalytics;

public abstract class BaseApplication
extends Application {
    public static FirebaseAnalytics analytics;
    private InterstitialAd mInterstitialAd;
    private String mLastAdUnitId;

    public abstract AdRequest createDefaultAdRequest();

    public abstract String getApplicationCode();

    @SuppressLint(value={"MissingPermission"})
    public void onCreate() {
        super.onCreate();
        analytics = FirebaseAnalytics.getInstance((Context)this);
        String applicationCode = this.getApplicationCode();
        if (applicationCode != null && !applicationCode.isEmpty()) {
            MobileAds.initialize((Context)this.getApplicationContext(), (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

                public void onInitializationComplete(InitializationStatus initializationStatus) {
                    BaseApplication.this.onMobileAdsInitializationComplete(initializationStatus);
                }
            });
        }
    }

    public void setupInterstitialAd(String adUnitId) {
        if (adUnitId != null && !adUnitId.equals(this.mLastAdUnitId)) {
            this.mLastAdUnitId = adUnitId;
            this.mInterstitialAd = new InterstitialAd((Context)this);
            this.mInterstitialAd.setAdUnitId(adUnitId);
            this.mInterstitialAd.setAdListener(new AdListener(){

                public void onAdClosed() {
                    BaseApplication.this.requestNewInterstitial();
                }
            });
            this.requestNewInterstitial();
        }
    }

    protected void onMobileAdsInitializationComplete(InitializationStatus initializationStatus) {
    }

    @SuppressLint(value={"MissingPermission"})
    private void requestNewInterstitial() {
        AdRequest adRequest = this.createDefaultAdRequest();
        this.mInterstitialAd.loadAd(adRequest);
    }

    public InterstitialAd getInterstitialAd() {
        return this.mInterstitialAd;
    }
}

