/*
 * Decompiled with CFR 0.152.
 */
package br.com.tattobr.android.adsanalytics;

import android.app.Application;
import android.content.Context;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.Tracker;

public abstract class BaseApplication
extends Application {
    public static GoogleAnalytics analytics;
    public static Tracker tracker;
    private InterstitialAd mInterstitialAd;
    private String mLastAdUnitId;

    protected abstract String getAnalyticsTrackingId();

    public abstract AdRequest createDefaultAdRequest();

    protected int getAnalyticsDispatchPeriodInSeconds() {
        return 1800;
    }

    protected boolean getAnalyticsDryRun() {
        return false;
    }

    protected boolean getTrackerEnableExceptionReporting() {
        return true;
    }

    protected boolean getTrackerEnableAdvertisingIdCollection() {
        return true;
    }

    protected boolean getTrackerEnableAutoActivityTracking() {
        return true;
    }

    public void onCreate() {
        super.onCreate();
        analytics = GoogleAnalytics.getInstance((Context)this);
        analytics.setLocalDispatchPeriod(this.getAnalyticsDispatchPeriodInSeconds());
        analytics.setDryRun(this.getAnalyticsDryRun());
        tracker = analytics.newTracker(this.getAnalyticsTrackingId());
        tracker.enableExceptionReporting(this.getTrackerEnableExceptionReporting());
        tracker.enableAdvertisingIdCollection(this.getTrackerEnableAdvertisingIdCollection());
        tracker.enableAutoActivityTracking(this.getTrackerEnableAutoActivityTracking());
    }

    public void setupInterstitialAd(String adUnitId) {
        if (adUnitId != null && !adUnitId.equals(this.mLastAdUnitId)) {
            this.mLastAdUnitId = adUnitId;
            this.mInterstitialAd = new InterstitialAd((Context)this);
            this.mInterstitialAd.setAdUnitId(adUnitId);
            this.mInterstitialAd.setAdListener(new AdListener(){

                public void onAdClosed() {
                    BaseApplication.this.requestNewInterstitial();
                }
            });
            this.requestNewInterstitial();
        }
    }

    private void requestNewInterstitial() {
        AdRequest adRequest = this.createDefaultAdRequest();
        this.mInterstitialAd.loadAd(adRequest);
    }

    public InterstitialAd getInterstitialAd() {
        return this.mInterstitialAd;
    }
}

