/*
 * Copyright (C) 2011-2022 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.testing.fs;

import br.com.objectos.collections.list.ImmutableList;
import br.com.objectos.core.object.Checks;
import br.com.objectos.fs.Directory;
import java.io.IOException;

enum DirectoryListMode {

  ALL,

  FILES;

  final ImmutableList<String> list(Directory directory) throws IOException {
    Checks.checkNotNull(directory, "directory == null");

    DirectoryListBuilder builder;
    builder = new DirectoryListBuilder(this);

    return builder.build(directory);
  }

}