/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.testing.fs;

import br.com.objectos.core.io.Resource;
import br.com.objectos.fs.Directory;
import br.com.objectos.fs.LocalFs;
import br.com.objectos.fs.RegularFile;
import java.io.IOException;

abstract class TestInf {
    private static final TestInf INSTANCE = TestInf.create();

    TestInf() {
    }

    public static Directory get() throws IOException {
        return INSTANCE.getImpl();
    }

    private static TestInf create() {
        try {
            Resource marker = Resource.getResource((String)"TEST-INF/.marker");
            RegularFile markerFile = LocalFs.getRegularFile((Resource)marker);
            Directory parent = markerFile.getParent();
            return new Success(parent);
        }
        catch (IOException e) {
            return new Failed(e);
        }
    }

    abstract Directory getImpl() throws IOException;

    private static class Success
    extends TestInf {
        private final Directory directory;

        Success(Directory directory) {
            this.directory = directory;
        }

        @Override
        final Directory getImpl() throws IOException {
            return this.directory;
        }
    }

    private static class Failed
    extends TestInf {
        private final IOException exception;

        Failed(IOException exception) {
            this.exception = exception;
        }

        @Override
        final Directory getImpl() throws IOException {
            throw this.exception;
        }
    }
}

