/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.testing.fs;

import br.com.objectos.collections.list.ImmutableList;
import br.com.objectos.collections.list.Lists;
import br.com.objectos.collections.list.MutableList;
import br.com.objectos.fs.Directory;
import br.com.objectos.fs.DirectoryContentsVisitor;
import br.com.objectos.fs.RegularFile;
import br.com.objectos.testing.fs.DirectoryListMode;
import java.io.File;
import java.io.IOException;

final class DirectoryListBuilder
implements DirectoryContentsVisitor {
    private final MutableList<String> leafs = MutableList.create();
    private final DirectoryListMode mode;
    private String prefix = "";

    DirectoryListBuilder(DirectoryListMode mode) {
        this.mode = mode;
    }

    public final ImmutableList<String> build(Directory directory) throws IOException {
        directory.visitContents((DirectoryContentsVisitor)this);
        this.leafs.sort(Lists.naturalOrder());
        return this.leafs.toImmutableList();
    }

    public final void visitDirectory(Directory directory) throws IOException {
        String previousPrefix = this.prefix;
        String directoryName = directory.getName();
        this.prefix = this.prefix + directoryName;
        this.prefix = this.prefix + File.separatorChar;
        switch (this.mode) {
            case FILES: {
                break;
            }
            default: {
                this.leafs.add((Object)this.prefix);
            }
        }
        directory.visitContents((DirectoryContentsVisitor)this);
        this.prefix = previousPrefix;
    }

    public final void visitRegularFile(RegularFile file) throws IOException {
        String leaf = this.prefix + file.getName();
        this.leafs.add((Object)leaf);
    }
}

