/*
 * Decompiled with CFR 0.152.
 */
package br.com.arch.toolkit.statemachine;

import android.support.annotation.NonNull;
import android.view.View;
import br.com.arch.toolkit.statemachine.StateMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ViewStateMachine
extends StateMachine<State> {
    @Override
    @NonNull
    public State newStateInstance() {
        return new State();
    }

    @Override
    protected void performChangeState(@NonNull State state) {
        for (View view : state.gones) {
            if (view == null) continue;
            view.setVisibility(8);
        }
        for (View view : state.visibles) {
            if (view == null) continue;
            view.setVisibility(0);
        }
        for (View view : state.invisibles) {
            if (view == null) continue;
            view.setVisibility(4);
        }
        for (View view : state.enables) {
            if (view == null) continue;
            view.setEnabled(true);
        }
        for (View view : state.disables) {
            if (view == null) continue;
            view.setEnabled(false);
        }
    }

    public static final class State
    extends StateMachine.State {
        @NonNull
        private final List<View> visibles = new ArrayList<View>();
        @NonNull
        private final List<View> gones = new ArrayList<View>();
        @NonNull
        private final List<View> invisibles = new ArrayList<View>();
        @NonNull
        private final List<View> enables = new ArrayList<View>();
        @NonNull
        private final List<View> disables = new ArrayList<View>();

        private State() {
        }

        public final State visibles(View ... views) {
            this.visibles.addAll(Arrays.asList(views));
            return this;
        }

        public final State invisibles(View ... views) {
            this.invisibles.addAll(Arrays.asList(views));
            return this;
        }

        public final State gones(View ... views) {
            this.gones.addAll(Arrays.asList(views));
            return this;
        }

        public final State enables(View ... views) {
            this.enables.addAll(Arrays.asList(views));
            return this;
        }

        public final State disables(View ... views) {
            this.disables.addAll(Arrays.asList(views));
            return this;
        }
    }
}

