/*
 * Decompiled with CFR 0.152.
 */
package br.com.arch.toolkit.statemachine;

import android.os.Bundle;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002./B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J?\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\b\b\u0002\u0010\u001c\u001a\u00020\u00132%\b\u0002\u0010\u001d\u001a\u001f\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001eJ\"\u0010\u0007\u001a\u00020\u001a2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u001e\u00a2\u0006\u0002\b#H\u0086\bJ\u0015\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010&J\u0012\u0010'\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\u0006\u0010+\u001a\u00020\u001aJ\u001b\u0010%\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\f2\u0006\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u0010,J*\u0010%\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\f2\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u001e\u00a2\u0006\u0002\b#H\u0086\bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR&\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u0017j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u0000`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lbr/com/arch/toolkit/statemachine/StateMachine;", "STATE", "Lbr/com/arch/toolkit/statemachine/StateMachine$State;", "", "stateCreator", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "config", "Lbr/com/arch/toolkit/statemachine/StateMachine$Config;", "getConfig", "()Lbr/com/arch/toolkit/statemachine/StateMachine$Config;", "<set-?>", "", "currentStateKey", "getCurrentStateKey", "()I", "setCurrentStateKey", "(I)V", "started", "", "getStateCreator", "()Lkotlin/jvm/functions/Function0;", "stateMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "changeState", "", "stateKey", "forceChange", "onChangeState", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "key", "configuration", "Lkotlin/ExtensionFunctionType;", "performChangeState", "state", "(Lbr/com/arch/toolkit/statemachine/StateMachine$State;)V", "restoreInstanceState", "savedInstanceState", "Landroid/os/Bundle;", "saveInstanceState", "start", "(ILbr/com/arch/toolkit/statemachine/StateMachine$State;)V", "stateConfig", "Config", "State", "statemachine_release"})
public abstract class StateMachine<STATE extends State> {
    private int currentStateKey;
    private final HashMap<Integer, STATE> stateMap;
    @NotNull
    private final Config config;
    private boolean started;
    @NotNull
    private final Function0<STATE> stateCreator;

    public final int getCurrentStateKey() {
        return this.currentStateKey == -1 ? this.config.getInitialState() : this.currentStateKey;
    }

    private final void setCurrentStateKey(int n) {
        this.currentStateKey = n;
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    protected abstract void performChangeState(@NotNull STATE var1);

    public final void config(@NotNull Function1<? super Config, Unit> configuration) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Config config = this.getConfig();
        configuration.invoke((Object)config);
    }

    public final void start() {
        if (this.started) {
            throw (Throwable)new IllegalStateException("Machine already started");
        }
        if (this.getCurrentStateKey() > -1 && (State)this.stateMap.get(this.getCurrentStateKey()) == null) {
            throw (Throwable)new IllegalStateException("State not found! Make sure to add all states before init the Machine");
        }
        this.started = true;
        if (this.getCurrentStateKey() > -1) {
            StateMachine.changeState$default(this, this.getCurrentStateKey(), true, null, 4, null);
        }
    }

    public final void changeState(int stateKey, boolean forceChange, @Nullable Function1<? super Integer, Unit> onChangeState) {
        if (!this.started) {
            throw (Throwable)new IllegalStateException("Call StateMachine$start() method before make any state changes");
        }
        if (stateKey == this.getCurrentStateKey() && !forceChange) {
            return;
        }
        State state = (State)this.stateMap.get(stateKey);
        if (state == null) {
            throw (Throwable)new IllegalStateException("State " + stateKey + " not exists! Make sure to setup the State Machine before change the states!");
        }
        State state2 = state;
        Function0<Unit> function0 = (Function0<Unit>)this.stateMap.get(this.getCurrentStateKey());
        if (function0 != null && (function0 = function0.getExit()) != null) {
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
        State state3 = state2;
        Intrinsics.checkExpressionValueIsNotNull((Object)state3, (String)"state");
        this.performChangeState(state3);
        Function0<Unit> function02 = state2.getEnter();
        if (function02 != null) {
            Unit cfr_ignored_1 = (Unit)function02.invoke();
        }
        Function1<? super Integer, Unit> function1 = onChangeState;
        if (function1 != null) {
            Unit cfr_ignored_2 = (Unit)function1.invoke((Object)stateKey);
        }
        this.currentStateKey = stateKey;
    }

    public static /* bridge */ /* synthetic */ void changeState$default(StateMachine stateMachine, int n, boolean bl, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: changeState");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            function1 = stateMachine.config.getOnChangeState();
        }
        stateMachine.changeState(n, bl, function1);
    }

    public final void state(int key, @NotNull Function1<? super STATE, Unit> stateConfig) {
        Intrinsics.checkParameterIsNotNull(stateConfig, (String)"stateConfig");
        Object object = this.getStateCreator().invoke();
        int n = key;
        StateMachine stateMachine = this;
        stateConfig.invoke(object);
        Object object2 = object;
        stateMachine.state(n, (State)object2);
    }

    public final void state(int key, @NotNull STATE state) {
        Intrinsics.checkParameterIsNotNull(state, (String)"state");
        if (this.started) {
            throw (Throwable)new IllegalStateException("Machine already started");
        }
        if (key < 0) {
            throw (Throwable)new IllegalStateException("State Keys must be >= 0");
        }
        Map map = this.stateMap;
        Integer n = key;
        STATE STATE = state;
        map.put(n, STATE);
    }

    public void restoreInstanceState(@Nullable Bundle savedInstanceState) {
        if (this.started) {
            throw (Throwable)new IllegalStateException("Machine already started");
        }
        Bundle bundle = savedInstanceState;
        this.currentStateKey = bundle != null ? bundle.getInt("STATE_MACHINE_CURRENT_KEY", this.getCurrentStateKey()) : this.getCurrentStateKey();
    }

    @NotNull
    public Bundle saveInstanceState() {
        Bundle bundle;
        Bundle $receiver = bundle = new Bundle();
        $receiver.putInt("STATE_MACHINE_CURRENT_KEY", this.getCurrentStateKey());
        this.started = false;
        return bundle;
    }

    @NotNull
    public final Function0<STATE> getStateCreator() {
        return this.stateCreator;
    }

    public StateMachine(@NotNull Function0<? extends STATE> stateCreator) {
        Intrinsics.checkParameterIsNotNull(stateCreator, (String)"stateCreator");
        this.stateCreator = stateCreator;
        this.currentStateKey = -1;
        StateMachine stateMachine = this;
        HashMap hashMap = new HashMap();
        stateMachine.stateMap = hashMap;
        this.config = new Config();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR7\u0010\t\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lbr/com/arch/toolkit/statemachine/StateMachine$Config;", "", "()V", "initialState", "", "getInitialState", "()I", "setInitialState", "(I)V", "onChangeState", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "key", "", "getOnChangeState", "()Lkotlin/jvm/functions/Function1;", "setOnChangeState", "(Lkotlin/jvm/functions/Function1;)V", "statemachine_release"})
    public static final class Config {
        private int initialState = -1;
        @Nullable
        private Function1<? super Integer, Unit> onChangeState;

        public final int getInitialState() {
            return this.initialState;
        }

        public final void setInitialState(int n) {
            this.initialState = n;
        }

        @Nullable
        public final Function1<Integer, Unit> getOnChangeState() {
            return this.onChangeState;
        }

        public final void setOnChangeState(@Nullable Function1<? super Integer, Unit> function1) {
            this.onChangeState = function1;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000e\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0014\u0010\u0010\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R4\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR4\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\n\u00a8\u0006\u0011"}, d2={"Lbr/com/arch/toolkit/statemachine/StateMachine$State;", "", "()V", "<set-?>", "Lkotlin/Function0;", "", "enter", "getEnter", "()Lkotlin/jvm/functions/Function0;", "setEnter", "(Lkotlin/jvm/functions/Function0;)V", "exit", "getExit", "setExit", "onEnter", "func", "onExit", "statemachine_release"})
    public static class State {
        @Nullable
        private Function0<Unit> enter;
        @Nullable
        private Function0<Unit> exit;

        @Nullable
        public final Function0<Unit> getEnter() {
            return this.enter;
        }

        private final void setEnter(Function0<Unit> function0) {
            this.enter = function0;
        }

        @Nullable
        public final Function0<Unit> getExit() {
            return this.exit;
        }

        private final void setExit(Function0<Unit> function0) {
            this.exit = function0;
        }

        public final void onEnter(@NotNull Function0<Unit> func) {
            Intrinsics.checkParameterIsNotNull(func, (String)"func");
            this.enter = func;
        }

        public final void onExit(@NotNull Function0<Unit> func) {
            Intrinsics.checkParameterIsNotNull(func, (String)"func");
            this.exit = func;
        }
    }
}

