/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.learner;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.jafama.FastMath;

public class ObjFunction
implements Serializable {
    private static final Map<String, ObjFunction> FUNCTIONS = new HashMap<String, ObjFunction>();

    public static ObjFunction fromName(String name) {
        ObjFunction result = FUNCTIONS.get(name);
        if (result == null) {
            throw new IllegalArgumentException(name + " is not supported objective function.");
        }
        return result;
    }

    public static void register(String name, ObjFunction objFunction) {
        FUNCTIONS.put(name, objFunction);
    }

    public static void useFastMathExp(boolean useJafama) {
        if (useJafama) {
            ObjFunction.register("binary:logistic", new RegLossObjLogistic_Jafama());
            ObjFunction.register("reg:logistic", new RegLossObjLogistic_Jafama());
            ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb_Jafama());
        } else {
            ObjFunction.register("binary:logistic", new RegLossObjLogistic());
            ObjFunction.register("reg:logistic", new RegLossObjLogistic());
            ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb());
        }
    }

    public double[] predTransform(double[] preds) {
        return preds;
    }

    public double predTransform(double pred) {
        return pred;
    }

    static {
        ObjFunction.register("rank:pairwise", new ObjFunction());
        ObjFunction.register("binary:logistic", new RegLossObjLogistic());
        ObjFunction.register("binary:logitraw", new ObjFunction());
        ObjFunction.register("multi:softmax", new SoftmaxMultiClassObjClassify());
        ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb());
        ObjFunction.register("reg:linear", new ObjFunction());
        ObjFunction.register("reg:logistic", new RegLossObjLogistic());
    }

    static class SoftmaxMultiClassObjProb_Jafama
    extends SoftmaxMultiClassObjProb {
        SoftmaxMultiClassObjProb_Jafama() {
        }

        @Override
        double exp(double x) {
            return FastMath.exp((double)x);
        }
    }

    static class SoftmaxMultiClassObjProb
    extends ObjFunction {
        SoftmaxMultiClassObjProb() {
        }

        @Override
        public double[] predTransform(double[] preds) {
            int i;
            double max = preds[0];
            for (int i2 = 1; i2 < preds.length; ++i2) {
                max = Math.max(preds[i2], max);
            }
            double sum = 0.0;
            for (i = 0; i < preds.length; ++i) {
                preds[i] = this.exp(preds[i] - max);
                sum += preds[i];
            }
            i = 0;
            while (i < preds.length) {
                int n = i++;
                preds[n] = preds[n] / (double)((float)sum);
            }
            return preds;
        }

        @Override
        public double predTransform(double pred) {
            throw new UnsupportedOperationException();
        }

        double exp(double x) {
            return Math.exp(x);
        }
    }

    static class SoftmaxMultiClassObjClassify
    extends ObjFunction {
        SoftmaxMultiClassObjClassify() {
        }

        @Override
        public double[] predTransform(double[] preds) {
            int maxIndex = 0;
            double max = preds[0];
            for (int i = 1; i < preds.length; ++i) {
                if (!(max < preds[i])) continue;
                maxIndex = i;
                max = preds[i];
            }
            return new double[]{maxIndex};
        }

        @Override
        public double predTransform(double pred) {
            throw new UnsupportedOperationException();
        }
    }

    static class RegLossObjLogistic_Jafama
    extends RegLossObjLogistic {
        RegLossObjLogistic_Jafama() {
        }

        @Override
        double sigmoid(double x) {
            return 1.0 / (1.0 + FastMath.exp((double)(-x)));
        }
    }

    static class RegLossObjLogistic
    extends ObjFunction {
        RegLossObjLogistic() {
        }

        @Override
        public double[] predTransform(double[] preds) {
            for (int i = 0; i < preds.length; ++i) {
                preds[i] = this.sigmoid(preds[i]);
            }
            return preds;
        }

        @Override
        public double predTransform(double pred) {
            return this.sigmoid(pred);
        }

        double sigmoid(double x) {
            return 1.0 / (1.0 + Math.exp(-x));
        }
    }
}

