/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import java.util.Set;

public class LatchedLockManager
extends LockManager {
    public LatchedLockManager(EnvironmentImpl envImpl) throws DatabaseException {
        super(envImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock lookupLock(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            Lock lock = this.lookupLockInternal(nodeId, lockTableIndex);
            return lock;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LockManager.LockAttemptResult attemptLock(Long nodeId, Locker locker, LockType type, boolean nonBlockingRequest) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            LockManager.LockAttemptResult lockAttemptResult = this.attemptLockInternal(nodeId, locker, type, nonBlockingRequest, lockTableIndex);
            return lockAttemptResult;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeadlockException makeTimeoutMsg(String lockOrTxn, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            DeadlockException deadlockException = this.makeTimeoutMsgInternal(lockOrTxn, locker, nodeId, type, grantType, useLock, timeout, start, now, database);
            return deadlockException;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set releaseAndFindNotifyTargets(long nodeId, Locker locker) throws DatabaseException {
        long nid = nodeId;
        int lockTableIndex = this.getLockTableIndex(nid);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            Set set = this.releaseAndFindNotifyTargetsInternal(nodeId, locker, lockTableIndex);
            return set;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transfer(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.transferInternal(nodeId, owningLocker, destLocker, demoteToRead, lockTableIndex);
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transferMultiple(long nodeId, Locker owningLocker, Locker[] destLockers) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.transferMultipleInternal(nodeId, owningLocker, destLockers, lockTableIndex);
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void demote(long nodeId, Locker locker) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.demoteInternal(nodeId, locker, lockTableIndex);
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLocked(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.isLockedInternal(nodeId, lockTableIndex);
            return bl;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOwner(Long nodeId, Locker locker, LockType type) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.isOwnerInternal(nodeId, locker, type, lockTableIndex);
            return bl;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isWaiter(Long nodeId, Locker locker) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.isWaiterInternal(nodeId, locker, lockTableIndex);
            return bl;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nWaiters(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            int n = this.nWaitersInternal(nodeId, lockTableIndex);
            return n;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nOwners(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            int n = this.nOwnersInternal(nodeId, lockTableIndex);
            return n;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Locker getWriteOwnerLocker(Long nodeId) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            Locker locker = this.getWriteOwnerLockerInternal(nodeId, lockTableIndex);
            return locker;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateOwnership(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            boolean bl = this.validateOwnershipInternal(nodeId, locker, type, flushFromWaiters, mb, lockTableIndex);
            return bl;
        }
        finally {
            latch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpLockTable(LockStats stats) throws DatabaseException {
        for (int i = 0; i < this.nLockTables; ++i) {
            this.lockTableLatches[i].acquire();
            try {
                this.dumpLockTableInternal(stats, i);
                continue;
            }
            finally {
                this.lockTableLatches[i].release();
            }
        }
    }
}

