/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.WriteLockInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BasicLocker
extends Locker {
    private Long ownedLock;
    private Set ownedLockSet;

    public BasicLocker(EnvironmentImpl env) throws DatabaseException {
        super(env, false, false);
    }

    protected long generateId(TxnManager txnManager) {
        return -1L;
    }

    protected void checkState(boolean ignoreCalledByAbort) throws DatabaseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LockResult lockInternal(long nodeId, LockType lockType, boolean noWait, DatabaseImpl database) throws DatabaseException {
        boolean useNoWait;
        BasicLocker basicLocker = this;
        synchronized (basicLocker) {
            this.checkState(false);
        }
        long timeout = 0L;
        boolean bl = useNoWait = noWait || this.defaultNoWait;
        if (!useNoWait) {
            BasicLocker basicLocker2 = this;
            synchronized (basicLocker2) {
                timeout = this.lockTimeOutMillis;
            }
        }
        LockGrantType grant = this.lockManager.lock(nodeId, this, lockType, timeout, useNoWait, database);
        return new LockResult(grant, null);
    }

    public Locker getWriteOwnerLocker(long nodeId) throws DatabaseException {
        return this.lockManager.getWriteOwnerLocker(new Long(nodeId));
    }

    public long getOwnerAbortLsn(long nodeId) throws DatabaseException {
        Locker ownerTxn = this.lockManager.getWriteOwnerLocker(new Long(nodeId));
        if (ownerTxn != null) {
            return ownerTxn.getAbortLsn(nodeId);
        }
        return -1L;
    }

    public boolean isTransactional() {
        return false;
    }

    public boolean isSerializableIsolation() {
        return false;
    }

    public boolean isReadCommittedIsolation() {
        return false;
    }

    public Txn getTxnLocker() {
        return null;
    }

    public Locker newNonTxnLocker() throws DatabaseException {
        return new BasicLocker(this.envImpl);
    }

    public void releaseNonTxnLocks() throws DatabaseException {
        this.operationEnd(true);
    }

    public void operationEnd() throws DatabaseException {
        this.operationEnd(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationEnd(boolean operationOK) throws DatabaseException {
        if (this.ownedLock != null) {
            this.lockManager.release(this.ownedLock, this);
            this.ownedLock = null;
        }
        if (this.ownedLockSet != null) {
            Iterator iter = this.ownedLockSet.iterator();
            while (iter.hasNext()) {
                Long nid = (Long)iter.next();
                this.lockManager.release(nid, this);
            }
            this.ownedLockSet.clear();
        }
        BasicLocker basicLocker = this;
        synchronized (basicLocker) {
            if (this.deleteInfo != null && this.deleteInfo.size() > 0) {
                this.envImpl.addToCompressorQueue(this.deleteInfo.values(), false);
                this.deleteInfo.clear();
            }
        }
    }

    public void setHandleLockOwner(boolean operationOK, Database dbHandle, boolean dbIsClosing) throws DatabaseException {
        if (dbHandle != null) {
            if (operationOK && !dbIsClosing) {
                this.transferHandleLockToHandle(dbHandle);
            } else {
                this.envImpl.releaseDb(DbInternal.dbGetDatabaseImpl(dbHandle));
            }
            this.unregisterHandle(dbHandle);
        }
    }

    public void registerCursor(CursorImpl cursor) throws DatabaseException {
    }

    public void unRegisterCursor(CursorImpl cursor) throws DatabaseException {
    }

    public long getAbortLsn(long nodeId) throws DatabaseException {
        return -1L;
    }

    public WriteLockInfo getWriteLockInfo(long nodeId) throws DatabaseException {
        return WriteLockInfo.basicWriteLockInfo;
    }

    public void markDeleteAtTxnEnd(DatabaseImpl db, boolean deleteAtCommit) throws DatabaseException {
        if (deleteAtCommit) {
            db.deleteAndReleaseINs();
        } else {
            this.envImpl.releaseDb(db);
        }
    }

    void addLock(Long nodeId, LockType type, LockGrantType grantStatus) throws DatabaseException {
        if (this.ownedLock != null && this.ownedLock.equals(nodeId) || this.ownedLockSet != null && this.ownedLockSet.contains(nodeId)) {
            return;
        }
        if (this.ownedLock == null) {
            this.ownedLock = nodeId;
        } else {
            if (this.ownedLockSet == null) {
                this.ownedLockSet = new HashSet();
            }
            this.ownedLockSet.add(nodeId);
        }
    }

    void removeLock(long nodeId) throws DatabaseException {
        if (this.ownedLock != null && this.ownedLock == nodeId) {
            this.ownedLock = null;
        } else if (this.ownedLockSet != null) {
            this.ownedLockSet.remove(new Long(nodeId));
        }
    }

    public boolean createdNode(long nodeId) throws DatabaseException {
        return false;
    }

    void moveWriteToReadLock(long nodeId, Lock lock) {
    }

    public LockStats collectStats(LockStats stats) throws DatabaseException {
        Lock l;
        if (this.ownedLock != null && (l = this.lockManager.lookupLock(this.ownedLock)) != null) {
            if (l.isOwnedWriteLock(this)) {
                stats.setNWriteLocks(stats.getNWriteLocks() + 1);
            } else {
                stats.setNReadLocks(stats.getNReadLocks() + 1);
            }
        }
        if (this.ownedLockSet != null) {
            Iterator iter = this.ownedLockSet.iterator();
            while (iter.hasNext()) {
                Long nid = (Long)iter.next();
                Lock l2 = this.lockManager.lookupLock(nid);
                if (l2 == null) continue;
                if (l2.isOwnedWriteLock(this)) {
                    stats.setNWriteLocks(stats.getNWriteLocks() + 1);
                    continue;
                }
                stats.setNReadLocks(stats.getNReadLocks() + 1);
            }
        }
        return stats;
    }
}

