/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.latch.LatchSupport;
import java.util.ArrayList;
import java.util.List;

public class LatchImpl
implements Latch {
    private static final String DEFAULT_LATCH_NAME = "LatchImpl";
    private String name = null;
    private List waiters = null;
    private LatchStats stats = new LatchStats();
    private EnvironmentImpl env = null;
    private Thread owner = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LatchImpl(String name, EnvironmentImpl env) {
        this.name = name;
        this.env = env;
    }

    public LatchImpl(EnvironmentImpl env) {
        this.env = env;
        this.name = DEFAULT_LATCH_NAME;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws DatabaseException {
        try {
            Thread thread = Thread.currentThread();
            LatchWaiter waitTarget = null;
            Object object = this;
            synchronized (object) {
                if (thread == this.owner) {
                    ++this.stats.nAcquiresSelfOwned;
                    throw new LatchException(this.getNameString() + " already held");
                }
                if (this.owner == null) {
                    ++this.stats.nAcquiresNoWaiters;
                    this.owner = thread;
                } else {
                    if (this.waiters == null) {
                        this.waiters = new ArrayList();
                    }
                    waitTarget = new LatchWaiter(thread);
                    this.waiters.add(waitTarget);
                    ++this.stats.nAcquiresWithContention;
                }
            }
            if (waitTarget != null) {
                object = waitTarget;
                synchronized (object) {
                    do {
                        if (waitTarget.active) {
                            if (thread == this.owner) break;
                            throw new DatabaseException("waitTarget.active but not owner");
                        }
                        waitTarget.wait();
                    } while (thread != this.owner);
                }
            }
            if (!$assertionsDisabled && !this.noteLatch()) {
                throw new AssertionError();
            }
        }
        catch (InterruptedException e) {
            throw new RunRecoveryException(this.env, (Throwable)e);
        }
        finally {
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean acquireNoWait() throws LatchException {
        try {
            Thread thread = Thread.currentThread();
            if (thread == this.owner) {
                ++this.stats.nAcquiresSelfOwned;
                throw new LatchException(this.getNameString() + " already held");
            }
            if (this.owner == null) {
                this.owner = thread;
                ++this.stats.nAcquireNoWaitSuccessful;
                if (!$assertionsDisabled && !this.noteLatch()) {
                    throw new AssertionError();
                }
                boolean bl = true;
                return bl;
            }
            ++this.stats.nAcquireNoWaitUnsuccessful;
            boolean bl = false;
            return bl;
        }
        finally {
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
        }
    }

    public void releaseIfOwner() {
        this.doRelease(false);
    }

    public void release() throws LatchNotHeldException {
        if (this.doRelease(true)) {
            throw new LatchNotHeldException(this.getNameString() + " not held");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRelease(boolean checkHeld) {
        Object object;
        LatchWaiter newOwner = null;
        try {
            object = this;
            synchronized (object) {
                block16: {
                    Thread thread = Thread.currentThread();
                    if (thread == this.owner) break block16;
                    boolean bl = true;
                    return bl;
                }
                if (this.waiters != null && this.waiters.size() > 0) {
                    newOwner = (LatchWaiter)this.waiters.remove(0);
                    this.owner = newOwner.thread;
                } else {
                    this.owner = null;
                }
                ++this.stats.nReleases;
                if (!$assertionsDisabled && !this.unNoteLatch(checkHeld)) {
                    throw new AssertionError();
                }
            }
        }
        finally {
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
        }
        if (newOwner != null) {
            object = newOwner;
            synchronized (object) {
                newOwner.active = true;
                newOwner.notifyAll();
            }
        }
        return false;
    }

    public boolean isOwner() {
        return Thread.currentThread() == this.owner;
    }

    public Thread owner() {
        return this.owner;
    }

    public synchronized int nWaiters() {
        return this.waiters != null ? this.waiters.size() : 0;
    }

    public LatchStats getLatchStats() {
        LatchStats s = null;
        try {
            s = (LatchStats)this.stats.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return s;
    }

    public synchronized String toString() {
        return LatchSupport.latchTable.toString(this.name, this.owner, this.waiters, 0);
    }

    private String getNameString() {
        return LatchSupport.latchTable.getNameString(this.name);
    }

    private boolean noteLatch() throws LatchException {
        return LatchSupport.latchTable.noteLatch(this);
    }

    private boolean unNoteLatch(boolean checkHeld) {
        if (checkHeld) {
            return LatchSupport.latchTable.unNoteLatch(this, this.name);
        }
        LatchSupport.latchTable.unNoteLatch(this, this.name);
        return true;
    }

    static {
        $assertionsDisabled = !LatchImpl.class.desiredAssertionStatus();
    }

    private static class LatchWaiter {
        boolean active;
        Thread thread;

        LatchWaiter(Thread thread) {
            this.thread = thread;
            this.active = false;
        }

        public String toString() {
            return "<LatchWaiter: " + this.thread + ">";
        }
    }
}

