/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.client.parser;

import be.yildizgames.common.file.xml.XMLParser;
import be.yildizgames.engine.client.parser.MusicDefinition;
import be.yildizgames.engine.client.parser.MusicParser;
import be.yildizgames.engine.client.parser.PlayListDefinition;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XmlMusicParser
implements MusicParser {
    XmlMusicParser() {
    }

    @Override
    public List<PlayListDefinition> parse(Path xmlFile) {
        ArrayList<PlayListDefinition> playListDefinitionList = new ArrayList<PlayListDefinition>();
        Document doc = XMLParser.getDocument((Path)xmlFile);
        NodeList playListList = doc.getElementsByTagName("playlist");
        for (int i = 0; i < playListList.getLength(); ++i) {
            Node playList = playListList.item(i);
            NodeList itemList = playList.getChildNodes();
            PlayListDefinition playListDefinition = new PlayListDefinition();
            for (int j = 0; j < itemList.getLength(); ++j) {
                Node item = itemList.item(j);
                String itemName = item.getNodeName();
                if ("name".equals(itemName)) {
                    playListDefinition.setName(item.getTextContent());
                    continue;
                }
                if (!"music".equals(itemName)) continue;
                MusicDefinition musicDef = new MusicDefinition();
                NodeList musicItemList = item.getChildNodes();
                for (int k = 0; k < musicItemList.getLength(); ++k) {
                    Node musicItem = musicItemList.item(k);
                    String musicItemName = musicItem.getNodeName();
                    if ("name".equals(musicItemName)) {
                        musicDef.setName(musicItem.getTextContent());
                        continue;
                    }
                    if (!"file".equals(musicItemName)) continue;
                    musicDef.setFile(musicItem.getTextContent());
                }
                playListDefinition.addMusic(musicDef);
            }
            playListDefinitionList.add(playListDefinition);
        }
        return playListDefinitionList;
    }
}

