/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.client.parser;

import be.yildizgames.common.file.xml.XMLParser;
import be.yildizgames.engine.client.parser.MaterialParser;
import be.yildizgames.engine.client.parser.SimpleMaterialDefinition;
import be.yildizgames.module.window.ScreenSize;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XmlMaterialParser
implements MaterialParser {
    private final ScreenSize screenSize;

    XmlMaterialParser(ScreenSize screenSize) {
        this.screenSize = screenSize;
    }

    @Override
    public List<SimpleMaterialDefinition> parse(Path xmlFile) {
        ArrayList<SimpleMaterialDefinition> resultList = new ArrayList<SimpleMaterialDefinition>();
        Document doc = XMLParser.getDocument((Path)xmlFile);
        NodeList materialList = doc.getElementsByTagName("material");
        for (int i = 0; i < materialList.getLength(); ++i) {
            Node material = materialList.item(i);
            NodeList itemList = material.getChildNodes();
            SimpleMaterialDefinition matDefinition = new SimpleMaterialDefinition();
            block21: for (int j = 0; j < itemList.getLength(); ++j) {
                Node item = itemList.item(j);
                String value = item.getTextContent();
                switch (item.getNodeName()) {
                    case "name": {
                        matDefinition.setName(value);
                        continue block21;
                    }
                    case "file": {
                        matDefinition.setPath(value.replace("$screenWidth", String.valueOf(this.screenSize.width)).replace("$screenHeight", String.valueOf(this.screenSize.height)));
                        continue block21;
                    }
                    case "file2": {
                        matDefinition.setPath2(value.replace("$screenWidth", String.valueOf(this.screenSize.width)).replace("$screenHeight", String.valueOf(this.screenSize.height)));
                        continue block21;
                    }
                    case "transparency": {
                        matDefinition.setTransparency(value);
                        continue block21;
                    }
                    case "glowFile": {
                        matDefinition.setGlowFile(value);
                        continue block21;
                    }
                    case "light": {
                        matDefinition.setAffectedByLight(value);
                        continue block21;
                    }
                    case "blend": {
                        matDefinition.setBlend(value);
                        continue block21;
                    }
                    case "sceneBlend": {
                        matDefinition.setSceneBlend(value);
                        continue block21;
                    }
                }
            }
            resultList.add(matDefinition);
        }
        return resultList;
    }
}

