/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.client.parser;

import be.yildizgames.common.geometry.Point3D;

final class LightDefinition {
    private String name = "";
    private String type = "point";
    private Point3D position = Point3D.ZERO;
    private String lightMaterial = "empty";
    private String haloMaterial = "empty";
    private String burstMaterial = "empty";

    void setX(String positionX) {
        if (positionX == null) {
            throw new IllegalArgumentException("positionX is mandatory");
        }
        this.position = Point3D.valueOf((float)Float.parseFloat(positionX), (float)this.position.y, (float)this.position.z);
    }

    void setY(String positionY) {
        if (positionY == null) {
            throw new IllegalArgumentException("positionY is mandatory");
        }
        this.position = Point3D.valueOf((float)this.position.x, (float)Float.parseFloat(positionY), (float)this.position.z);
    }

    void setZ(String positionZ) {
        if (positionZ == null) {
            throw new IllegalArgumentException("positionZ is mandatory");
        }
        this.position = Point3D.valueOf((float)this.position.x, (float)this.position.y, (float)Float.parseFloat(positionZ));
    }

    void setLightMaterial(String light) {
        if (light == null || light.isEmpty()) {
            throw new IllegalArgumentException("Light material is mandatory");
        }
        this.lightMaterial = light;
    }

    void setHaloMaterial(String halo) {
        if (halo == null || halo.isEmpty()) {
            throw new IllegalArgumentException("Halo material is mandatory");
        }
        this.haloMaterial = halo;
    }

    void setBurstMaterial(String burst) {
        if (burst == null || burst.isEmpty()) {
            throw new IllegalArgumentException("Burst material is mandatory");
        }
        this.burstMaterial = burst;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Point3D getPosition() {
        return this.position;
    }

    public String getLightMaterial() {
        return this.lightMaterial;
    }

    public String getHaloMaterial() {
        return this.haloMaterial;
    }

    public String getBurstMaterial() {
        return this.burstMaterial;
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name is mandatory");
        }
        this.name = name;
    }

    public void setType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Type is mandatory");
        }
        if (!"point".equals(type)) {
            throw new IllegalArgumentException("Type values allowed: point");
        }
        this.type = type;
    }
}

