/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.client.parser;

import be.yildizgames.engine.client.parser.ButtonDefinition;
import be.yildizgames.engine.client.parser.GuiCommonDefinition;
import be.yildizgames.engine.client.parser.ImageDefinition;
import be.yildizgames.engine.client.parser.InputBoxDefinition;
import be.yildizgames.engine.client.parser.TextAreaDefinition;
import be.yildizgames.engine.client.parser.TextLineDefinition;
import be.yildizgames.module.graphic.material.Material;
import be.yildizgames.module.window.ScreenSize;
import java.util.ArrayList;
import java.util.List;

public final class ContainerDefinition
extends GuiCommonDefinition {
    private final List<ImageDefinition> imageList = new ArrayList<ImageDefinition>();
    private final List<TextLineDefinition> textLineList = new ArrayList<TextLineDefinition>();
    private final List<ButtonDefinition> buttonList = new ArrayList<ButtonDefinition>();
    private final List<InputBoxDefinition> inputBoxList = new ArrayList<InputBoxDefinition>();
    private final List<TextAreaDefinition> textAreaList = new ArrayList<TextAreaDefinition>();
    private Material material = Material.empty();
    private int z;

    ContainerDefinition(ScreenSize screen) {
        super(screen);
    }

    void setMaterial(String materialName) {
        this.material = Material.get((String)materialName);
    }

    void setZ(String zValue) {
        this.z = Integer.parseInt(zValue);
    }

    void addImage(ImageDefinition imageDef) {
        this.imageList.add(imageDef);
    }

    void addTextLine(TextLineDefinition textLineDef) {
        this.textLineList.add(textLineDef);
    }

    void addButton(ButtonDefinition buttonDef) {
        this.buttonList.add(buttonDef);
    }

    void addInputBox(InputBoxDefinition inputDef) {
        this.inputBoxList.add(inputDef);
    }

    void addTextArea(TextAreaDefinition textAreaDef) {
        this.textAreaList.add(textAreaDef);
    }

    public List<ImageDefinition> getImageList() {
        return this.imageList;
    }

    public List<TextLineDefinition> getTextLineList() {
        return this.textLineList;
    }

    public List<ButtonDefinition> getButtonList() {
        return this.buttonList;
    }

    public List<InputBoxDefinition> getInputBoxList() {
        return this.inputBoxList;
    }

    public List<TextAreaDefinition> getTextAreaList() {
        return this.textAreaList;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getZ() {
        return this.z;
    }
}

