/*
 * Decompiled with CFR 0.152.
 */
package com.d2lvalence.idkeyauth.implementation;

import com.d2lvalence.idkeyauth.D2LUserContextParameters;
import com.d2lvalence.idkeyauth.ID2LUserContext;
import com.d2lvalence.idkeyauth.implementation.D2LSigner;
import com.d2lvalence.idkeyauth.implementation.DefaultTimestampProvider;
import com.d2lvalence.idkeyauth.implementation.ITimestampProvider;
import com.d2lvalence.idkeyauth.implementation.TimestampParser;
import java.net.URI;
import java.net.URISyntaxException;

public class D2LUserContext
implements ID2LUserContext {
    private final String instanceUrl;
    private final String appId;
    private final String appKey;
    private final String userId;
    private final String userKey;
    private long _serverSkewMillis;
    private final ITimestampProvider _timestampProvider;
    private static final String APP_ID_PARAMETER = "x_a";
    private static final String USER_ID_PARAMETER = "x_b";
    private static final String SIGNATURE_BY_APP_KEY_PARAMETER = "x_c";
    private static final String SIGNATURE_BY_USER_KEY_PARAMETER = "x_d";
    private static final String TIMESTAMP_PARAMETER = "x_t";

    public D2LUserContext(String url, String appId, String appKey, String userId, String userKey) {
        this.instanceUrl = url;
        this.appId = appId;
        this.appKey = appKey;
        this.userId = userId;
        this.userKey = userKey;
        this._timestampProvider = new DefaultTimestampProvider();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public long getServerSkewMillis() {
        return this._serverSkewMillis;
    }

    public void setServerSkewMillis(long _serverSkewMillis) {
        this._serverSkewMillis = _serverSkewMillis;
    }

    public URI createAuthenticatedUri(String path, String httpMethod) {
        int split = path.indexOf("?");
        String query = "";
        if (split >= 0) {
            query = path.substring(split + 1);
            path = path.substring(0, split);
        }
        String queryString = this.getQueryString(path, query, httpMethod);
        try {
            URI uri = new URI(this.instanceUrl + path + queryString);
            return uri;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean calculateServerSkewFromResponse(String responseBody) {
        TimestampParser timestampParser = new TimestampParser();
        long serverTimestampSeconds = timestampParser.tryParseTimestamp(responseBody);
        if (serverTimestampSeconds > 0L) {
            long clientTimestampMilliseconds = this._timestampProvider.getCurrentTimestampInMilliseconds();
            this._serverSkewMillis = serverTimestampSeconds * 1000L - clientTimestampMilliseconds;
            return true;
        }
        return false;
    }

    private String buildAuthenticatedUriQueryString(String signature, long timestamp) {
        String queryString = "?x_a=" + this.appId;
        if (this.getUserId() != null) {
            queryString = queryString + "&x_b=" + this.getUserId();
        }
        queryString = queryString + "&x_c";
        queryString = queryString + "=" + D2LSigner.getBase64HashString(this.appKey, signature);
        if (this.getUserId() != null) {
            queryString = queryString + "&x_d";
            queryString = queryString + "=" + D2LSigner.getBase64HashString(this.getUserKey(), signature);
        }
        queryString = queryString + "&x_t=" + timestamp;
        return queryString;
    }

    private long getAdjustedTimestampInSeconds() {
        long timestampMilliseconds = this._timestampProvider.getCurrentTimestampInMilliseconds();
        long adjustedTimestampSeconds = (timestampMilliseconds + this._serverSkewMillis) / 1000L;
        return adjustedTimestampSeconds;
    }

    private String getQueryString(String path, String query, String httpMethod) {
        long adjustedTimestampSeconds = this.getAdjustedTimestampInSeconds();
        String signature = D2LUserContext.formatSignature(path, httpMethod, adjustedTimestampSeconds);
        String queryString = this.buildAuthenticatedUriQueryString(signature, adjustedTimestampSeconds);
        if (query != null) {
            queryString = queryString + "&" + query;
        }
        return queryString;
    }

    private static String formatSignature(String path, String httpMethod, long timestampSeconds) {
        return httpMethod.toUpperCase() + "&" + URI.create(path).getPath().toLowerCase() + "&" + timestampSeconds;
    }

    public int interpretResult(int resultCode, String responseBody) {
        if (resultCode == 200) {
            return 1;
        }
        if (resultCode == 403) {
            if (this.calculateServerSkewFromResponse(responseBody)) {
                return 3;
            }
            if (responseBody.toLowerCase().equals("invalid token") || responseBody.toLowerCase().equals("token expired")) {
                return 2;
            }
            return 4;
        }
        return 0;
    }

    public String getHostName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getPort() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Deprecated
    public D2LUserContextParameters getParameters() {
        return new D2LUserContextParameters(this.appId, this.appKey, this.userId, this.userKey, this.userId);
    }
}

