/*
 * Decompiled with CFR 0.152.
 */
package com.d2lvalence.idkeyauth.implementation;

import com.d2lvalence.idkeyauth.D2LUserContextParameters;
import com.d2lvalence.idkeyauth.ID2LAppContext;
import com.d2lvalence.idkeyauth.ID2LUserContext;
import com.d2lvalence.idkeyauth.implementation.D2LConstants;
import com.d2lvalence.idkeyauth.implementation.D2LSigner;
import com.d2lvalence.idkeyauth.implementation.D2LUserContext;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class D2LAppContext
implements ID2LAppContext {
    private static final String APP_ID_PARAMETER = "x_a";
    private static final String APP_KEY_PARAMETER = "x_b";
    private static final String CALLBACK_URL_PARAMETER = "x_target";
    private static final String TYPE_PARAMETER = "type";
    private static final String TYPE_PARAMETER_VALUE = "mobile";
    private static final String USER_ID_CALLBACK_PARAMETER = "x_a";
    private static final String USER_KEY_CALLBACK_PARAMETER = "x_b";
    private final String _appId;
    private final String _appKey;
    private String _url;

    public D2LAppContext(String appId, String appKey, String url) {
        this._appId = appId;
        this._appKey = appKey;
        this._url = url != null && url.endsWith("/") ? url.substring(0, url.lastIndexOf("/")) : url;
    }

    @Override
    public URI createWebUrlForAuthentication(URI redirectUrl) {
        try {
            URI uri = new URI(this._url + D2LConstants.AUTHENTICATION_SERVICE_URI_PATH + "?" + this.buildAuthenticationUriQueryString(redirectUrl));
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private HashMap<String, String> getParameters(String queryString) {
        String[] strings;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : strings = queryString.split("&")) {
            String[] split = s.split("=");
            if (split.length != 2) continue;
            result.put(split[0], split[1]);
        }
        return result;
    }

    @Override
    public ID2LUserContext createUserContext(URI uri) {
        if (uri.getQuery() != null) {
            HashMap<String, String> r = this.getParameters(uri.getQuery());
            String userId = r.get("x_a");
            String userKey = r.get("x_b");
            if (userId == null || userKey == null) {
                return null;
            }
            return new D2LUserContext(this._url, this._appId, this._appKey, userId, userKey);
        }
        return null;
    }

    @Override
    public ID2LUserContext createUserContext(String userId, String userKey) {
        return new D2LUserContext(this._url, this._appId, this._appKey, userId, userKey);
    }

    @Override
    public ID2LUserContext createAnonymousUserContext() {
        return new D2LUserContext(this._url, this._appId, this._appKey, null, null);
    }

    private String buildAuthenticationUriQueryString(URI callbackUri) {
        String callbackUriString = callbackUri.toString();
        String uriHash = D2LSigner.getBase64HashString(this._appKey, callbackUriString);
        String result = "x_a=" + this._appId;
        result = result + "&x_b=" + uriHash;
        try {
            result = result + "&x_target=" + URLEncoder.encode(callbackUriString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result = result + "&x_target=" + URLEncoder.encode(callbackUriString);
        }
        return result;
    }

    public String getAppId() {
        return this._appId;
    }

    public String getAppKey() {
        return this._appKey;
    }

    public String getUrl() {
        return this._url;
    }

    @Override
    @Deprecated
    public ID2LUserContext createUserContext(D2LUserContextParameters parameters) {
        return this.createUserContext(parameters.getUserId(), parameters.getUserKey());
    }

    @Override
    @Deprecated
    public URI createWebUrlForAuthentication(String host, int port, URI resultUri) {
        return this.createWebUrlForAuthentication(host, port, true, resultUri);
    }

    @Override
    @Deprecated
    public URI createWebUrlForAuthentication(String host, int port, boolean encryptOperations, URI resultUri) {
        String protocol = encryptOperations ? D2LConstants.URI_SECURE_SCHEME : D2LConstants.URI_UNSECURE_SCHEME;
        this._url = protocol + "://" + host + ":" + port;
        return this.createWebUrlForAuthentication(resultUri);
    }

    @Override
    @Deprecated
    public ID2LUserContext createUserContext(URI uri, String hostName, int port, boolean encryptOperations) {
        String protocol = encryptOperations ? D2LConstants.URI_SECURE_SCHEME : D2LConstants.URI_UNSECURE_SCHEME;
        this._url = protocol + "://" + hostName + ":" + port;
        return this.createUserContext(uri);
    }

    @Override
    @Deprecated
    public ID2LUserContext createUserContext(String userId, String userKey, String hostName, int port, boolean encryptOperations) {
        String protocol = encryptOperations ? D2LConstants.URI_SECURE_SCHEME : D2LConstants.URI_UNSECURE_SCHEME;
        this._url = protocol + "://" + hostName + ":" + port;
        return this.createUserContext(userId, userKey);
    }

    @Override
    @Deprecated
    public ID2LUserContext createAnonymousUserContext(String hostName, int port, boolean encryptOperations) {
        String protocol = encryptOperations ? D2LConstants.URI_SECURE_SCHEME : D2LConstants.URI_UNSECURE_SCHEME;
        this._url = protocol + "://" + hostName + ":" + port;
        return this.createAnonymousUserContext();
    }
}

