/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.itunesapi;

import be.ceau.itunesapi.http.Connector;
import be.ceau.itunesapi.http.URLConnector;
import be.ceau.itunesapi.request.Country;
import be.ceau.itunesapi.request.Entity;
import be.ceau.itunesapi.request.lookup.Sort;
import be.ceau.itunesapi.response.Response;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lookup
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Lookup.class);
    private static final long serialVersionUID = 1479238701182L;
    private static final String API_ENDPOINT = "https://itunes.apple.com/lookup?";
    private static final String ID = "id";
    private static final String AMG_ARTIST_ID = "amgArtistId";
    private static final String AMG_ALBUM_ID = "amgAlbumId";
    private static final String AMG_VIDEO_ID = "amgVideoId";
    private static final String UPC = "upc";
    private static final String ISBN = "isbn";
    private final Map<String, Set<String>> map;
    private Entity entity;
    private int limit;
    private Sort sort;
    private Country country;

    public Lookup() {
        HashMap map = new HashMap();
        map.put(ID, new HashSet());
        map.put(AMG_ARTIST_ID, new HashSet());
        map.put(AMG_ALBUM_ID, new HashSet());
        map.put(AMG_VIDEO_ID, new HashSet());
        map.put(UPC, new HashSet());
        map.put(ISBN, new HashSet());
        this.map = Collections.unmodifiableMap(map);
    }

    public Response execute() {
        return this.execute(URLConnector.INSTANCE);
    }

    public Response execute(Connector connector) {
        if (connector == null) {
            throw new IllegalArgumentException("connector can not be null");
        }
        try {
            String url = this.build();
            String response = connector.get(url);
            logger.trace("{} -> {}", (Object)url, (Object)response);
            return (Response)Response.READER.readValue(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getIds() {
        return this.map.get(ID);
    }

    public Lookup addId(String id) {
        if (id != null) {
            this.map.get(ID).add(id);
        }
        return this;
    }

    public Lookup setIds(Collection<String> ids) {
        this.map.get(ID).clear();
        if (ids != null) {
            for (String id : ids) {
                this.addId(id);
            }
        }
        return this;
    }

    public Set<String> getAmgArtistIds() {
        return this.map.get(AMG_ARTIST_ID);
    }

    public Lookup addAmgArtistId(String amgArtistId) {
        if (amgArtistId != null) {
            this.map.get(AMG_ARTIST_ID).add(amgArtistId);
        }
        return this;
    }

    public Lookup setAmgArtistIds(Collection<String> amgArtistIds) {
        this.map.get(AMG_ARTIST_ID).clear();
        if (amgArtistIds != null) {
            for (String amgArtistId : amgArtistIds) {
                this.addAmgArtistId(amgArtistId);
            }
        }
        return this;
    }

    public Set<String> getAmgAlbumIds() {
        return this.map.get(AMG_ALBUM_ID);
    }

    public Lookup addAmgAlbumId(String amgAlbumId) {
        if (amgAlbumId != null) {
            this.map.get(AMG_ALBUM_ID).add(amgAlbumId);
        }
        return this;
    }

    public Lookup setAmgAlbumId(Collection<String> amgAlbumIds) {
        this.map.get(AMG_ALBUM_ID).clear();
        if (amgAlbumIds != null) {
            for (String amgAlbumId : amgAlbumIds) {
                this.addAmgAlbumId(amgAlbumId);
            }
        }
        return this;
    }

    public Set<String> getAmgVideoIds() {
        return this.map.get(AMG_VIDEO_ID);
    }

    public Lookup addAmgVideoId(String amgVideoId) {
        if (amgVideoId != null) {
            this.map.get(AMG_VIDEO_ID).add(amgVideoId);
        }
        return this;
    }

    public Lookup setAmgVideoIds(Collection<String> amgVideoIds) {
        this.map.get(AMG_VIDEO_ID).clear();
        if (amgVideoIds != null) {
            for (String amgVideoId : amgVideoIds) {
                this.addAmgVideoId(amgVideoId);
            }
        }
        return this;
    }

    public Set<String> getUpcs() {
        return this.map.get(UPC);
    }

    public Lookup addUpc(String upc) {
        if (upc != null) {
            this.map.get(UPC).add(upc);
        }
        return this;
    }

    public Lookup setUpcs(Collection<String> upcs) {
        this.map.get(UPC).clear();
        if (upcs != null) {
            for (String upc : upcs) {
                this.addUpc(upc);
            }
        }
        return this;
    }

    public Set<String> getIsbns() {
        return this.map.get(ISBN);
    }

    public Lookup addIsbn(String isbn) {
        if (isbn != null) {
            this.map.get(ISBN).add(isbn);
        }
        return this;
    }

    public Lookup setIsbns(Collection<String> isbns) {
        this.map.get(ISBN).clear();
        if (isbns != null) {
            for (String isbn : isbns) {
                this.addIsbn(isbn);
            }
        }
        return this;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Lookup setEntity(Entity entity) {
        this.entity = entity;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public Lookup setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Lookup setSort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public Country getCountry() {
        return this.country;
    }

    public Lookup setCountry(Country country) {
        this.country = country;
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<String>> entry : this.map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            try {
                String q = URLEncoder.encode(String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()), "UTF-8");
                sb.append(entry.getKey()).append("=").append(q);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.entity != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("entity").append("=").append(this.entity.getName());
        }
        if (this.limit > 0) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("limit").append("=").append(this.limit);
        }
        if (this.sort != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("sort").append("=").append(this.sort.toString());
        }
        if (this.country != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("country").append("=").append(this.country.getIso());
        }
        return API_ENDPOINT + sb.toString();
    }
}

