/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart.objects;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;

@JsonSerialize(using=Serializer.class)
public class OptionalArray<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1470940649764L;

    public static class Serializer<T>
    extends JsonSerializer<OptionalArray<T>> {
        public boolean isEmpty(SerializerProvider provider, OptionalArray<T> value) {
            return value == null || value.isEmpty();
        }

        public void serialize(OptionalArray<T> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null && !value.isEmpty()) {
                if (value.size() == 1) {
                    jgen.writeObject(value.get(0));
                } else {
                    jgen.writeStartArray();
                    for (Object t : value) {
                        jgen.writeObject(t);
                    }
                    jgen.writeEndArray();
                }
            }
        }
    }
}

