/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart;

import be.ceau.chart.Chart;
import be.ceau.chart.data.RadarData;
import be.ceau.chart.dataset.RadarDataset;
import be.ceau.chart.options.RadarOptions;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class RadarChart
implements Chart {
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter().forType(RadarChart.class);
    private final String type = "radar";
    private RadarData data;
    private RadarOptions options;

    public static RadarData data() {
        return new RadarData();
    }

    public static RadarOptions options() {
        return new RadarOptions();
    }

    public RadarChart() {
    }

    public RadarChart(RadarData data) {
        this.data = data;
    }

    public RadarChart(RadarData data, RadarOptions options) {
        this.data = data;
        this.options = options;
    }

    public RadarData getData() {
        return this.data;
    }

    public RadarChart setData(RadarData data) {
        this.data = data;
        return this;
    }

    public RadarOptions getOptions() {
        return this.options;
    }

    public RadarChart setOptions(RadarOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public String getType() {
        return "radar";
    }

    @Override
    public String toJson() {
        try {
            return WRITER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDrawable() {
        for (RadarDataset dataset : this.data.getDatasets()) {
            if (dataset.getData().size() <= 2) continue;
            return true;
        }
        return false;
    }
}

