/*
 * Decompiled with CFR 0.152.
 */
package be.appfoundry.progressbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import be.appfoundry.progressbutton.CircleView;
import be.appfoundry.progressbutton.R;
import be.appfoundry.progressbutton.util.LayoutUtil;

public class ProgressButton
extends FrameLayout {
    private CircleView circleView;
    private ImageView imageView;
    private int color;
    private int strokeColor;
    private int progressColor;
    private float strokeWidth;
    private float maxProgress = 100.0f;
    private float animationStep = 1.0f;
    private boolean isIndeterminate = true;
    private boolean reverse = false;
    private Drawable icon;
    private float radius;
    private float progress;
    private boolean isAnimating = false;
    private float startDegrees = 270.0f;
    private int animationDelay = 0;
    private Handler animationHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (ProgressButton.this.isAnimating) {
                ProgressButton.this.handleAnimation();
            }
        }
    };

    public ProgressButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.progress_button, (ViewGroup)this, true);
        this.circleView = (CircleView)view.findViewById(R.id.circle_view);
        this.imageView = (ImageView)this.findViewById(R.id.icon);
        TypedArray attr = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ProgressButton, 0, 0);
        try {
            this.color = attr.getColor(R.styleable.ProgressButton_fillColor, -1);
            this.circleView.setColor(this.color);
            this.strokeColor = attr.getColor(R.styleable.ProgressButton_strokeColor, -1);
            this.circleView.setStrokeColor(this.strokeColor);
            this.progressColor = attr.getColor(R.styleable.ProgressButton_progressColor, -1);
            this.circleView.setProgressColor(this.progressColor);
            this.strokeWidth = attr.getDimension(R.styleable.ProgressButton_strokeWidth, 0.0f);
            this.circleView.setStroke(this.strokeWidth);
            this.isIndeterminate = attr.getBoolean(R.styleable.ProgressButton_indeterminate, true);
            this.circleView.setIndeterminate(this.isIndeterminate);
            this.icon = attr.getDrawable(R.styleable.ProgressButton_progressIcon);
            this.setIcon(this.icon);
        }
        finally {
            attr.recycle();
        }
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(float maxProgress) {
        this.maxProgress = maxProgress;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        float degrees = 360.0f * progress / this.maxProgress;
        this.circleView.setDegrees(degrees);
        this.invalidate();
    }

    public void setStartDegrees(float degrees) {
        this.startDegrees = degrees;
        this.circleView.setStartDegrees(degrees);
        this.invalidate();
    }

    public void setProgressStart(float progress, float startDegrees) {
        this.progress = progress;
        this.startDegrees = startDegrees;
        this.circleView.setStartDegrees(startDegrees);
        float degrees = 360.0f * progress / this.maxProgress;
        this.circleView.setDegrees(degrees);
        this.invalidate();
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.isIndeterminate = indeterminate;
    }

    public Drawable getIcon() {
        return this.icon;
    }

    public void setIcon(Drawable icon) {
        this.icon = icon;
        this.imageView.setBackground(icon);
        this.invalidate();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.circleView.setRadius(radius);
        this.invalidate();
    }

    public void setAnimationStep(float animationStep) {
        this.animationStep = animationStep;
    }

    public void setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int size;
        super.onMeasure(widthMeasureSpec, widthMeasureSpec);
        int width = this.getLayoutParams().width;
        int height = this.getLayoutParams().height;
        int get_width = this.getWidth();
        int get_height = this.getHeight();
        int resolved_width = ProgressButton.resolveSize((int)get_width, (int)widthMeasureSpec);
        int resolved_height = ProgressButton.resolveSize((int)get_height, (int)heightMeasureSpec);
        if (this.radius > 0.0f) {
            size = (int)(this.radius * 2.0f);
        } else if (this.getLayoutParams().width == -1 && this.getLayoutParams().height == -1) {
            size = resolved_width;
            if (size > resolved_height) {
                size = resolved_height;
            }
        } else if (this.getLayoutParams().width == -1 && this.getLayoutParams().height != -1) {
            size = resolved_height;
        } else if (this.getLayoutParams().height == -1 && this.getLayoutParams().width != -1) {
            size = resolved_width;
        } else if (this.getLayoutParams().width == -2 && this.getLayoutParams().height == -2) {
            size = (int)LayoutUtil.convertDpToPixel(this.getContext(), 48.0f);
        } else if (this.getLayoutParams().width == -2 && this.getLayoutParams().height != -2) {
            size = resolved_height;
        } else if (this.getLayoutParams().height == -2 && this.getLayoutParams().width != -2) {
            size = resolved_width;
        } else if (width > height) {
            size = resolved_height;
        } else if (width < height) {
            size = resolved_width;
        } else if (resolved_height == 0) {
            size = width;
            if (size > resolved_width) {
                size = resolved_width;
            }
        } else if (resolved_width == 0) {
            size = height;
            if (size > resolved_height) {
                size = resolved_height;
            }
        } else {
            size = resolved_width;
            if (size > resolved_height) {
                size = resolved_height;
            }
        }
        this.setMeasuredDimension(size, size);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.radius == 0.0f) {
            this.circleView.setRadius(this.getWidth() / 2);
        }
    }

    public void startAnimating() {
        if (!this.isAnimating) {
            this.isAnimating = true;
            this.animationHandler.sendEmptyMessage(0);
        }
    }

    public void stopAnimating() {
        if (this.isAnimating) {
            this.animationHandler.removeMessages(0);
            this.progress = 0.0f;
            this.reverse = false;
            this.startDegrees = 270.0f;
            this.setProgressStart(this.progress, this.startDegrees);
            this.isAnimating = false;
            this.invalidate();
        }
    }

    private void handleAnimation() {
        if (this.isIndeterminate) {
            if (this.progress >= this.maxProgress) {
                this.reverse = true;
                this.progress = this.maxProgress;
                this.startDegrees = 270.0f;
            } else if (this.progress <= 0.0f) {
                this.reverse = false;
                this.progress = 0.0f;
                this.startDegrees = 270.0f;
            }
            if (this.reverse) {
                float degrees1 = 360.0f * this.progress / this.maxProgress;
                this.progress -= this.animationStep;
                float degrees2 = 360.0f * this.progress / this.maxProgress;
                float diff = degrees1 - degrees2;
                this.startDegrees += diff;
            } else {
                this.progress += this.animationStep;
            }
        }
        this.setProgressStart(this.progress, this.startDegrees);
        this.animationHandler.sendEmptyMessageDelayed(0, (long)this.animationDelay);
    }
}

