/*
 * Decompiled with CFR 0.152.
 */
package be.appfoundry.progressbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import be.appfoundry.progressbutton.R;

public class CircleView
extends View {
    private int color;
    private int strokeColor;
    private int progressColor;
    private float radius;
    private float stroke;
    private boolean indeterminate;
    private Paint circlePaint = new Paint();
    private Paint progressPaint = new Paint();
    private Paint strokePaint = new Paint();
    private Paint shadowPaint = new Paint();
    private float degrees;
    private float startDegrees = 270.0f;

    public CircleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.invalidate();
        this.requestLayout();
    }

    public float getStroke() {
        return this.stroke;
    }

    public void setStroke(float stroke) {
        this.stroke = stroke;
        this.invalidate();
        this.requestLayout();
    }

    public float getDegrees() {
        return this.degrees;
    }

    public void setDegrees(float degrees) {
        this.degrees = degrees;
        this.invalidate();
        this.requestLayout();
    }

    public float getStartDegrees() {
        return this.startDegrees;
    }

    public void setStartDegrees(float startDegrees) {
        this.startDegrees = startDegrees;
        this.invalidate();
        this.requestLayout();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.circlePaint.setColor(color);
        this.invalidate();
        this.requestLayout();
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        this.strokePaint.setColor(strokeColor);
        this.invalidate();
        this.requestLayout();
    }

    public int getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(int progressColor) {
        this.progressColor = progressColor;
        this.progressPaint.setColor(progressColor);
        this.invalidate();
        this.requestLayout();
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
        this.invalidate();
        this.requestLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.circlePaint = new Paint(1);
        this.progressPaint = new Paint(1);
        this.strokePaint = new Paint(1);
        this.shadowPaint = new Paint(1);
        TypedArray attr = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircleView, 0, 0);
        try {
            this.color = attr.getColor(R.styleable.CircleView_innerColor, -1);
            this.circlePaint.setColor(this.color);
            this.strokeColor = attr.getColor(R.styleable.CircleView_outerColor, -1);
            this.strokePaint.setColor(this.strokeColor);
            this.progressColor = attr.getColor(R.styleable.CircleView_outerColor, -1);
            this.progressPaint.setColor(this.progressColor);
            this.radius = attr.getInteger(R.styleable.CircleView_radius, 0);
        }
        finally {
            attr.recycle();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.radius == 0.0f) {
            this.radius = this.getWidth() / 2;
        }
        RectF mTempRectF = new RectF();
        float left = (float)(this.getWidth() / 2) - this.radius;
        float right = (float)(this.getWidth() / 2) + this.radius;
        float top = (float)(this.getHeight() / 2) - this.radius;
        float bottom = (float)(this.getHeight() / 2) + this.radius;
        mTempRectF.set(left, top, right, bottom);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), this.radius, this.strokePaint);
        canvas.drawArc(mTempRectF, this.startDegrees, this.degrees, true, this.progressPaint);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), this.radius - this.stroke, this.circlePaint);
    }
}

