/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.java2wsdl.Java2WSDLConstants;
import org.apache.ws.java2wsdl.Java2WSDLUtils;
import org.apache.ws.java2wsdl.bytecode.MethodTable;
import org.apache.ws.java2wsdl.utils.TypeTable;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JMethod;
import org.codehaus.jam.JParameter;
import org.codehaus.jam.JProperty;
import org.codehaus.jam.JamClassIterator;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;

public class SchemaGenerator
implements Java2WSDLConstants {
    public static final String NAME_SPACE_PREFIX = "stn_";
    private static int prefixCount = 1;
    protected Map targetNamespacePrefixMap = new Hashtable();
    protected Map schemaMap = new Hashtable();
    protected XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
    private static final Log log = LogFactory.getLog((Class)SchemaGenerator.class);
    private ClassLoader classLoader;
    private String className;
    private TypeTable typeTable = new TypeTable();
    private JMethod[] methods;
    private MethodTable methodTable;
    private String schemaTargetNameSpace;
    private String schema_namespace_prefix;
    private Class clazz;
    private ArrayList excludeMethods = new ArrayList();

    public SchemaGenerator(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix) throws Exception {
        this.classLoader = loader;
        this.className = className;
        this.clazz = Class.forName(className, true, loader);
        this.methodTable = new MethodTable(this.clazz);
        this.schemaTargetNameSpace = schematargetNamespace != null && !schematargetNamespace.trim().equals("") ? schematargetNamespace : Java2WSDLUtils.schemaNamespaceFromClassName(className, loader).toString();
        this.schema_namespace_prefix = schematargetNamespacePrefix != null && !schematargetNamespacePrefix.trim().equals("") ? schematargetNamespacePrefix : "ns";
        XmlSchema xmlSchema = this.getXmlSchema(this.clazz.getPackage().getName(), this.schemaTargetNameSpace, this.schema_namespace_prefix);
        xmlSchema.getPrefixToNamespaceMap().put("xs", "http://www.w3.org/2001/XMLSchema");
    }

    public Collection generateSchema() throws Exception {
        JamServiceFactory factory = JamServiceFactory.getInstance();
        JamServiceParams jam_service_parms = factory.createServiceParams();
        jam_service_parms.addClassLoader(this.classLoader);
        jam_service_parms.includeClass(this.className);
        JamService service = factory.createService(jam_service_parms);
        JamClassIterator jClassIter = service.getClasses();
        while (jClassIter.hasNext()) {
            JClass jclass = (JClass)jClassIter.next();
            this.methods = jclass.getDeclaredMethods();
            HashMap<String, JMethod> uniqueMethods = new HashMap<String, JMethod>();
            for (int i = 0; i < this.methods.length; ++i) {
                JMethod jMethod = this.methods[i];
                if (this.excludeMethods.contains(jMethod.getSimpleName())) continue;
                if (uniqueMethods.get(jMethod.getSimpleName()) != null) {
                    throw new Exception(" Sorry we don't support methods overloading !!!! ");
                }
                if (!jMethod.isPublic()) continue;
                uniqueMethods.put(jMethod.getSimpleName(), jMethod);
                JParameter[] paras = jMethod.getParameters();
                for (int j = 0; j < paras.length; ++j) {
                    JParameter methodParameter = paras[j];
                    JClass paraType = methodParameter.getType();
                    String classTypeName = paraType.getQualifiedName();
                    if (paraType.isArrayType()) {
                        classTypeName = paraType.getArrayComponentType().getQualifiedName();
                        if (this.typeTable.isSimpleType(classTypeName)) continue;
                        this.generateSchema(paraType.getArrayComponentType());
                        continue;
                    }
                    if (this.typeTable.isSimpleType(classTypeName)) continue;
                    this.generateSchema(methodParameter.getType());
                }
                JClass retuenType = jMethod.getReturnType();
                if (retuenType.isVoidType()) continue;
                if (retuenType.isArrayType()) {
                    String returnTypeName = retuenType.getArrayComponentType().getQualifiedName();
                    if (this.typeTable.isSimpleType(returnTypeName)) continue;
                    this.generateSchema(retuenType.getArrayComponentType());
                    continue;
                }
                if (this.typeTable.isSimpleType(retuenType.getQualifiedName())) continue;
                this.generateSchema(retuenType);
            }
            this.generateWrapperElements(this.methods);
        }
        return this.schemaMap.values();
    }

    private void generateWrapperElements(JMethod[] methods) throws Exception {
        for (int i = 0; i < methods.length; ++i) {
            JMethod method = methods[i];
            if (this.excludeMethods.contains(method.getSimpleName()) || !method.isPublic()) continue;
            this.generateWrapperElementforMethod(method);
        }
    }

    private void generateWrapperElementforMethod(JMethod method) throws Exception {
        XmlSchema xmlSchema = this.getXmlSchema(this.clazz.getPackage().getName(), this.schemaTargetNameSpace, this.schema_namespace_prefix);
        String methodName = method.getSimpleName();
        XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        XmlSchemaElement eltOuter = new XmlSchemaElement();
        eltOuter.setName(methodName);
        eltOuter.setSchemaType((XmlSchemaType)complexType);
        QName elementName = new QName(this.schemaTargetNameSpace, eltOuter.getName(), this.schema_namespace_prefix);
        eltOuter.setQName(elementName);
        this.typeTable.addComplexSchema(methodName, elementName);
        xmlSchema.getItems().add((XmlSchemaObject)eltOuter);
        xmlSchema.getElements().add(elementName, (XmlSchemaObject)eltOuter);
        JParameter[] paras = method.getParameters();
        if (paras.length > 0) {
            complexType.setParticle((XmlSchemaParticle)sequence);
        }
        String[] parameterNames = null;
        if (paras.length > 0) {
            parameterNames = this.methodTable.getParameterNames(methodName);
        }
        for (int j = 0; j < paras.length; ++j) {
            XmlSchemaElement elt1;
            JParameter methodParameter = paras[j];
            String paraName = methodParameter.getSimpleName();
            String classTypeName = methodParameter.getType().getQualifiedName();
            boolean isArryType = methodParameter.getType().isArrayType();
            if (isArryType) {
                classTypeName = methodParameter.getType().getArrayComponentType().getQualifiedName();
            }
            if (parameterNames != null) {
                paraName = parameterNames[j];
            }
            if (this.typeTable.isSimpleType(classTypeName)) {
                elt1 = new XmlSchemaElement();
                elt1.setName(paraName);
                elt1.setSchemaTypeName(this.typeTable.getSimpleSchemaTypeName(classTypeName));
                sequence.getItems().add((XmlSchemaObject)elt1);
                if (!isArryType) continue;
                elt1.setMaxOccurs(Long.MAX_VALUE);
                elt1.setMinOccurs(0L);
                continue;
            }
            elt1 = new XmlSchemaElement();
            elt1.setName(paraName);
            elt1.setSchemaTypeName(this.typeTable.getComplexSchemaType(classTypeName));
            sequence.getItems().add((XmlSchemaObject)elt1);
            if (isArryType) {
                elt1.setMaxOccurs(Long.MAX_VALUE);
                elt1.setMinOccurs(0L);
            }
            if (xmlSchema.getPrefixToNamespaceMap().values().contains(this.typeTable.getComplexSchemaType(classTypeName).getNamespaceURI())) continue;
            XmlSchemaImport importElement = new XmlSchemaImport();
            importElement.setNamespace(this.typeTable.getComplexSchemaType(classTypeName).getNamespaceURI());
            xmlSchema.getItems().add((XmlSchemaObject)importElement);
            xmlSchema.getPrefixToNamespaceMap().put(this.generatePrefix(), this.typeTable.getComplexSchemaType(classTypeName).getNamespaceURI());
        }
        JClass methodReturnType = method.getReturnType();
        this.generateWrapperforReturnType(methodReturnType, methodName);
    }

    private void generateWrapperforReturnType(JClass retuenType, String methodName) throws Exception {
        XmlSchema xmlSchema = this.getXmlSchema(this.clazz.getPackage().getName(), this.schemaTargetNameSpace, this.schema_namespace_prefix);
        if (!retuenType.isVoidType()) {
            XmlSchemaComplexType retuen_com_type = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaElement ret_eltOuter = new XmlSchemaElement();
            ret_eltOuter.setName(methodName + "Response");
            ret_eltOuter.setSchemaType((XmlSchemaType)retuen_com_type);
            QName ret_comTypeName = new QName(this.schemaTargetNameSpace, ret_eltOuter.getName(), this.schema_namespace_prefix);
            xmlSchema.getItems().add((XmlSchemaObject)ret_eltOuter);
            xmlSchema.getElements().add(ret_comTypeName, (XmlSchemaObject)ret_eltOuter);
            this.typeTable.addComplexSchema(methodName + "Response", ret_comTypeName);
            String classTypeName = retuenType.getQualifiedName();
            boolean isArryType = retuenType.isArrayType();
            XmlSchemaSequence sequence = new XmlSchemaSequence();
            retuen_com_type.setParticle((XmlSchemaParticle)sequence);
            if (isArryType) {
                classTypeName = retuenType.getArrayComponentType().getQualifiedName();
            }
            if (this.typeTable.isSimpleType(classTypeName)) {
                XmlSchemaElement elt1 = new XmlSchemaElement();
                elt1.setName("return");
                elt1.setSchemaTypeName(this.typeTable.getSimpleSchemaTypeName(classTypeName));
                sequence.getItems().add((XmlSchemaObject)elt1);
                if (isArryType) {
                    elt1.setMaxOccurs(Long.MAX_VALUE);
                    elt1.setMinOccurs(0L);
                }
            } else {
                XmlSchemaElement elt1 = new XmlSchemaElement();
                elt1.setName("return");
                elt1.setSchemaTypeName(this.typeTable.getComplexSchemaType(classTypeName));
                sequence.getItems().add((XmlSchemaObject)elt1);
                if (isArryType) {
                    elt1.setMaxOccurs(Long.MAX_VALUE);
                    elt1.setMinOccurs(0L);
                }
                if (!xmlSchema.getPrefixToNamespaceMap().values().contains(this.typeTable.getComplexSchemaType(classTypeName).getNamespaceURI())) {
                    XmlSchemaImport importElement = new XmlSchemaImport();
                    importElement.setNamespace(this.typeTable.getComplexSchemaType(classTypeName).getNamespaceURI());
                    xmlSchema.getItems().add((XmlSchemaObject)importElement);
                    xmlSchema.getPrefixToNamespaceMap().put(this.generatePrefix(), this.typeTable.getComplexSchemaType(classTypeName).getNamespaceURI());
                }
            }
        }
    }

    public static String getCorrectName(String wrongName) {
        if (wrongName.length() > 1) {
            return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH) + wrongName.substring(1, wrongName.length());
        }
        return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH);
    }

    private void generateSchema(JClass javaType) {
        String name = javaType.getQualifiedName();
        if (this.typeTable.getComplexSchemaType(name) == null) {
            String simpleName = javaType.getSimpleName();
            String packageName = javaType.getContainingPackage().getQualifiedName();
            String targetNameSpace = Java2WSDLUtils.schemaNamespaceFromPackageName(packageName).toString();
            XmlSchema xmlSchema = this.getXmlSchema(packageName, targetNameSpace, this.generatePrefix());
            String targetNamespacePrefix = (String)this.targetNamespacePrefixMap.get(packageName);
            XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaSequence sequence = new XmlSchemaSequence();
            XmlSchemaElement eltOuter = new XmlSchemaElement();
            QName elemntName = new QName(targetNameSpace, simpleName, targetNamespacePrefix);
            eltOuter.setName(simpleName);
            eltOuter.setQName(elemntName);
            complexType.setParticle((XmlSchemaParticle)sequence);
            complexType.setName(simpleName);
            xmlSchema.getItems().add((XmlSchemaObject)eltOuter);
            xmlSchema.getElements().add(elemntName, (XmlSchemaObject)eltOuter);
            eltOuter.setSchemaTypeName(complexType.getQName());
            xmlSchema.getItems().add((XmlSchemaObject)complexType);
            xmlSchema.getSchemaTypes().add(elemntName, (XmlSchemaObject)complexType);
            this.typeTable.addComplexSchema(name, eltOuter.getQName());
            JProperty[] properties = javaType.getDeclaredProperties();
            for (int i = 0; i < properties.length; ++i) {
                XmlSchemaElement elt1;
                JProperty property = properties[i];
                String propertyName = property.getType().getQualifiedName();
                boolean isArryType = property.getType().isArrayType();
                if (isArryType) {
                    propertyName = property.getType().getArrayComponentType().getQualifiedName();
                }
                if (this.typeTable.isSimpleType(propertyName)) {
                    elt1 = new XmlSchemaElement();
                    elt1.setName(SchemaGenerator.getCorrectName(property.getSimpleName()));
                    elt1.setSchemaTypeName(this.typeTable.getSimpleSchemaTypeName(propertyName));
                    sequence.getItems().add((XmlSchemaObject)elt1);
                    if (!isArryType) continue;
                    elt1.setMaxOccurs(Long.MAX_VALUE);
                    elt1.setMinOccurs(0L);
                    continue;
                }
                if (isArryType) {
                    this.generateSchema(property.getType().getArrayComponentType());
                } else {
                    this.generateSchema(property.getType());
                }
                elt1 = new XmlSchemaElement();
                elt1.setName(SchemaGenerator.getCorrectName(property.getSimpleName()));
                elt1.setSchemaTypeName(this.typeTable.getComplexSchemaType(propertyName));
                sequence.getItems().add((XmlSchemaObject)elt1);
                if (isArryType) {
                    elt1.setMaxOccurs(Long.MAX_VALUE);
                    elt1.setMinOccurs(0L);
                }
                if (xmlSchema.getPrefixToNamespaceMap().values().contains(this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI())) continue;
                XmlSchemaImport importElement = new XmlSchemaImport();
                importElement.setNamespace(this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI());
                xmlSchema.getItems().add((XmlSchemaObject)importElement);
                xmlSchema.getPrefixToNamespaceMap().put(this.generatePrefix(), this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI());
            }
        }
    }

    private XmlSchema getXmlSchema(String packageName, String targetNamespace, String targetNamespacePrefix) {
        XmlSchema xmlSchema = (XmlSchema)this.schemaMap.get(packageName);
        if (xmlSchema == null) {
            xmlSchema = new XmlSchema(targetNamespace, this.xmlSchemaCollection);
            this.targetNamespacePrefixMap.put(packageName, targetNamespacePrefix);
            this.schemaMap.put(packageName, xmlSchema);
            Hashtable<String, String> prefixmap = new Hashtable<String, String>();
            prefixmap.put("xs", "http://www.w3.org/2001/XMLSchema");
            prefixmap.put(targetNamespacePrefix, targetNamespace);
            xmlSchema.setPrefixToNamespaceMap(prefixmap);
        }
        return xmlSchema;
    }

    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    public JMethod[] getMethods() {
        return this.methods;
    }

    private String generatePrefix() {
        return NAME_SPACE_PREFIX + prefixCount++;
    }

    public void setExcludeMethods(ArrayList excludeMethods) {
        this.excludeMethods = excludeMethods;
    }
}

