/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;

public class MessageContext
extends AbstractContext {
    protected Options options;
    public static final int IN_FLOW = 1;
    public static final int IN_FAULT_FLOW = 3;
    public static final int OUT_FLOW = 2;
    public static final int OUT_FAULT_FLOW = 4;
    public static final String REMOTE_ADDR = "REMOTE_ADDR";
    public static final String TRANSPORT_HEADERS = "TRANSPORT_HEADERS";
    public static final String TRANSPORT_OUT = "TRANSPORT_OUT";
    public static final String TRANSPORT_IN = "TRANSPORT_IN";
    public static final String CHARACTER_SET_ENCODING = "CHARACTER_SET_ENCODING";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16 = "utf-16";
    public static final String TRANSPORT_SUCCEED = "TRANSPORT_SUCCEED";
    public static final String DEFAULT_CHAR_SET_ENCODING = "UTF-8";
    public int FLOW = 1;
    public static final String TRANSPORT_NON_BLOCKING = "transportNonBlocking";
    private boolean processingFault;
    private boolean paused;
    public boolean outputWritten;
    private boolean newThreadRequired;
    private boolean isSOAP11 = true;
    private ArrayList executionChain = new ArrayList();
    private boolean doingREST;
    private boolean doingMTOM;
    private transient AxisOperation axisOperation;
    private transient AxisService axisService;
    private transient AxisServiceGroup axisServiceGroup;
    private ConfigurationContext configurationContext;
    private int currentHandlerIndex;
    private int currentPhaseIndex;
    private SOAPEnvelope envelope;
    private OperationContext operationContext;
    private boolean responseWritten;
    private boolean serverSide;
    private ServiceContext serviceContext;
    private String serviceContextID;
    private ServiceGroupContext serviceGroupContext;
    private String serviceGroupContextId;
    private SessionContext sessionContext;
    private transient TransportOutDescription transportOut;
    private transient TransportInDescription transportIn;
    private String incomingTransportName;

    public MessageContext() {
        super(null);
        this.options = new Options();
    }

    public void pause() {
        this.paused = true;
    }

    public AxisOperation getAxisOperation() {
        return this.axisOperation;
    }

    public AxisService getAxisService() {
        return this.axisService;
    }

    public AxisServiceGroup getAxisServiceGroup() {
        return this.axisServiceGroup;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public int getCurrentHandlerIndex() {
        return this.currentHandlerIndex;
    }

    public int getCurrentPhaseIndex() {
        return this.currentPhaseIndex;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public ArrayList getExecutionChain() {
        return this.executionChain;
    }

    public EndpointReference getFaultTo() {
        return this.options.getFaultTo();
    }

    public EndpointReference getFrom() {
        return this.options.getFrom();
    }

    public String getMessageID() {
        return this.options.getMessageId();
    }

    public Parameter getModuleParameter(String key, String moduleName, HandlerDescription handler) {
        AxisModule module;
        AxisConfiguration baseConfig;
        AxisServiceGroup axisServiceDesc;
        AxisService axisService;
        Parameter param;
        AxisOperation opDesc;
        ModuleConfiguration moduleConfig;
        if (this.getAxisOperation() != null && (moduleConfig = (opDesc = this.getAxisOperation()).getModuleConfig(new QName(moduleName))) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = opDesc.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if (this.getAxisService() != null && (moduleConfig = (axisService = this.getAxisService()).getModuleConfig(new QName(moduleName))) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = axisService.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if (this.getAxisServiceGroup() != null && (moduleConfig = (axisServiceDesc = this.getAxisServiceGroup()).getModuleConfig(new QName(moduleName))) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = axisServiceDesc.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if ((moduleConfig = (baseConfig = this.configurationContext.getAxisConfiguration()).getModuleConfig(new QName(moduleName))) != null) {
            param = moduleConfig.getParameter(key);
            if (param != null) {
                return param;
            }
            param = baseConfig.getParameter(key);
            if (param != null) {
                return param;
            }
        }
        if ((module = baseConfig.getModule(new QName(moduleName))) != null && (param = module.getParameter(key)) != null) {
            return param;
        }
        param = handler.getParameter(key);
        return param;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public Parameter getParameter(String key) {
        if (this.getAxisOperation() != null) {
            AxisOperation opDesc = this.getAxisOperation();
            return opDesc.getParameter(key);
        }
        if (this.getAxisService() != null) {
            AxisService axisService = this.getAxisService();
            return axisService.getParameter(key);
        }
        if (this.getAxisServiceGroup() != null) {
            AxisServiceGroup axisServiceDesc = this.getAxisServiceGroup();
            return axisServiceDesc.getParameter(key);
        }
        if (this.configurationContext != null) {
            AxisConfiguration baseConfig = this.configurationContext.getAxisConfiguration();
            return baseConfig.getParameter(key);
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        this.options.setProperty(name, value);
    }

    public Object getProperty(String name) {
        Object obj = this.options.getProperty(name);
        if (obj != null) {
            return obj;
        }
        if (this.operationContext != null) {
            return this.operationContext.getProperty(name);
        }
        if (this.serviceContext != null) {
            return this.serviceContext.getProperty(name);
        }
        if (this.serviceGroupContext != null) {
            return this.serviceGroupContext.getProperty(name);
        }
        if (this.configurationContext != null) {
            return this.configurationContext.getProperty(name);
        }
        return null;
    }

    public RelatesTo[] getRelationships() {
        return this.options.getRelationships();
    }

    public RelatesTo getRelatesTo(String type) {
        return this.options.getRelatesTo(type);
    }

    public RelatesTo getRelatesTo() {
        return this.options.getRelatesTo();
    }

    public EndpointReference getReplyTo() {
        return this.options.getReplyTo();
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public String getServiceContextID() {
        return this.serviceContextID;
    }

    public ServiceGroupContext getServiceGroupContext() {
        return this.serviceGroupContext;
    }

    public String getServiceGroupContextId() {
        return this.serviceGroupContextId;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public String getSoapAction() {
        return this.options.getAction();
    }

    public EndpointReference getTo() {
        return this.options.getTo();
    }

    public TransportInDescription getTransportIn() {
        return this.transportIn;
    }

    public TransportOutDescription getTransportOut() {
        return this.transportOut;
    }

    public String getWSAAction() {
        return this.options.getAction();
    }

    public boolean isDoingMTOM() {
        return this.doingMTOM;
    }

    public boolean isDoingREST() {
        return this.doingREST;
    }

    public boolean isNewThreadRequired() {
        return this.newThreadRequired;
    }

    public boolean isOutputWritten() {
        return this.outputWritten;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isProcessingFault() {
        return this.processingFault;
    }

    public boolean isResponseWritten() {
        return this.responseWritten;
    }

    public boolean isSOAP11() {
        return this.isSOAP11;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setAxisOperation(AxisOperation axisOperation) {
        this.axisOperation = axisOperation;
    }

    public void setAxisService(AxisService axisService) {
        this.axisService = axisService;
        this.axisServiceGroup = (AxisServiceGroup)this.axisService.getParent();
    }

    public void setAxisServiceGroup(AxisServiceGroup axisServiceGroup) {
        if (axisServiceGroup != null) {
            this.axisServiceGroup = axisServiceGroup;
        }
    }

    public void setConfigurationContext(ConfigurationContext context) {
        this.configurationContext = context;
    }

    public void setCurrentHandlerIndex(int currentHandlerIndex) {
        this.currentHandlerIndex = currentHandlerIndex;
    }

    public void setCurrentPhaseIndex(int currentPhaseIndex) {
        this.currentPhaseIndex = currentPhaseIndex;
    }

    public void setDoingMTOM(boolean b) {
        this.doingMTOM = b;
    }

    public void setDoingREST(boolean b) {
        this.doingREST = b;
    }

    public void setEnvelope(SOAPEnvelope envelope) throws AxisFault {
        this.envelope = envelope;
        String soapNamespaceURI = envelope.getNamespace().getName();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespaceURI)) {
            this.isSOAP11 = false;
        } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapNamespaceURI)) {
            this.isSOAP11 = true;
        } else {
            throw new AxisFault("Unknown SOAP Version. Current Axis handles only SOAP 1.1 and SOAP 1.2 messages");
        }
    }

    public void setExecutionChain(ArrayList executionChain) {
        this.executionChain = executionChain;
        this.currentHandlerIndex = -1;
        this.currentPhaseIndex = 0;
    }

    public void setFaultTo(EndpointReference reference) {
        this.options.setFaultTo(reference);
    }

    public void setFrom(EndpointReference reference) {
        this.options.setFrom(reference);
    }

    public void setMessageID(String messageId) {
        this.options.setMessageId(messageId);
    }

    public void setNewThreadRequired(boolean b) {
        this.newThreadRequired = b;
    }

    public void setOperationContext(OperationContext context) {
        this.operationContext = context;
        if (this.serviceContext != null && this.operationContext.getParent() == null) {
            this.operationContext.setParent(this.serviceContext);
        }
        this.setParent(this.operationContext);
        if (this.operationContext != null) {
            this.setAxisOperation(this.operationContext.getAxisOperation());
        }
    }

    public void setOutputWritten(boolean b) {
        this.outputWritten = b;
    }

    public void setProcessingFault(boolean b) {
        this.processingFault = b;
    }

    public void addRelatesTo(RelatesTo reference) {
        this.options.addRelatesTo(reference);
    }

    public void setReplyTo(EndpointReference referance) {
        this.options.setReplyTo(referance);
    }

    public void setResponseWritten(boolean b) {
        this.responseWritten = b;
    }

    public void setServerSide(boolean b) {
        this.serverSide = b;
    }

    public void setServiceContext(ServiceContext context) {
        this.serviceContext = context;
        if (this.operationContext != null && this.operationContext.getParent() != null) {
            this.operationContext.setParent(context);
        }
        if (this.configurationContext == null) {
            this.configurationContext = context.getConfigurationContext();
        }
        if (this.serviceGroupContext == null) {
            this.serviceGroupContext = context.getServiceGroupContext();
        }
        this.setAxisService(context.getAxisService());
    }

    public void setServiceContextID(String serviceContextID) {
        this.serviceContextID = serviceContextID;
    }

    public void setServiceGroupContext(ServiceGroupContext serviceGroupContext) {
        this.serviceGroupContext = serviceGroupContext;
        this.axisServiceGroup = serviceGroupContext.getDescription();
    }

    public void setServiceGroupContextId(String serviceGroupContextId) {
        this.serviceGroupContextId = serviceGroupContextId;
    }

    public void setSoapAction(String soapAction) {
        this.options.setAction(soapAction);
    }

    public void setTo(EndpointReference referance) {
        this.options.setTo(referance);
    }

    public void setTransportIn(TransportInDescription in) {
        this.transportIn = in;
    }

    public void setTransportOut(TransportOutDescription out) {
        this.transportOut = out;
    }

    public void setWSAAction(String actionURI) {
        this.options.setAction(actionURI);
    }

    public void setWSAMessageId(String messageID) {
        this.options.setMessageId(messageID);
    }

    public int getFLOW() {
        return this.FLOW;
    }

    public void setFLOW(int FLOW) {
        this.FLOW = FLOW;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options.setParent(options);
    }

    public String getIncomingTransportName() {
        return this.incomingTransportName;
    }

    public void setIncomingTransportName(String incomingTransportName) {
        this.incomingTransportName = incomingTransportName;
    }

    public void setRelationships(RelatesTo[] list) {
        this.options.setRelationships(list);
    }

    public boolean isEngaged(QName moduleName) {
        if (this.configurationContext != null) {
            AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
            AxisModule module = axisConfig.getModule(moduleName);
            if (module == null) {
                return false;
            }
            boolean enegage = axisConfig.isEngaged(moduleName);
            if (enegage) {
                return true;
            }
            if (this.axisServiceGroup != null && (enegage = this.axisServiceGroup.isEngaged(moduleName))) {
                return true;
            }
            if (this.axisService != null && (enegage = this.axisService.isEngaged(moduleName))) {
                return true;
            }
            if (this.axisOperation != null && (enegage = this.axisOperation.isEngaged(module))) {
                return true;
            }
        }
        return false;
    }

    public boolean isHeaderPresent() {
        OMElement node = this.getEnvelope().getFirstElement();
        return node == null || !node.getQName().getLocalPart().equals("Body");
    }
}

