/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d.image;

import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.java2d.image.ImageUtil;
import com.openhtmltopdf.layout.LayoutContext;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class ImageReplacedElement
implements ReplacedElement {
    protected Image _image;
    private Point _location = new Point(0, 0);

    protected ImageReplacedElement() {
    }

    public ImageReplacedElement(Image image, int targetWidth, int targetHeight) {
        if (targetWidth > 0 || targetHeight > 0) {
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            int newW = targetWidth;
            int newH = targetHeight;
            if (newW == -1) {
                newW = (int)((double)w * ((double)newH / (double)h));
            }
            if (newH == -1) {
                newH = (int)((double)h * ((double)newW / (double)w));
            }
            if (w != newW || h != newH) {
                image = image instanceof BufferedImage ? ImageUtil.getScaledInstance((BufferedImage)image, newW, newH) : image.getScaledInstance(newW, newH, 4);
            }
        }
        this._image = image;
    }

    public void detach(LayoutContext c) {
    }

    public int getIntrinsicHeight() {
        return this._image.getHeight(null);
    }

    public int getIntrinsicWidth() {
        return this._image.getWidth(null);
    }

    public Point getLocation() {
        return this._location;
    }

    public boolean isRequiresInteractivePaint() {
        return true;
    }

    public void setLocation(int x, int y) {
        this._location = new Point(x, y);
    }

    public Image getImage() {
        return this._image;
    }

    public int getBaseline() {
        return 0;
    }

    public boolean hasBaseline() {
        return false;
    }
}

