/*
 * Decompiled with CFR 0.152.
 */
package at.allaboutapps.web.webview;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import at.allaboutapps.web.webview.A3WebFragment;
import at.allaboutapps.web.webview.WebViewSettings;

public class A3WebActivity
extends AppCompatActivity {
    private static final String EXTRA_TITLE = "extra_title";
    private static final String EXTRA_SUBTITLE = "extra_subtitle";
    private static final String EXTRA_HOME_AS_UP = "extra_home_as_up";
    private static final String EXTRA_SETTINGS = "extra_settings";
    private A3WebFragment mFragment;

    public static Builder with(Context context, WebViewSettings settings) {
        return new Builder(context, settings);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            WebViewSettings settings = (WebViewSettings)this.getIntent().getParcelableExtra(EXTRA_SETTINGS);
            this.mFragment = A3WebFragment.newInstance(settings);
            this.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)this.mFragment).commit();
        } else {
            this.mFragment = (A3WebFragment)this.getSupportFragmentManager().findFragmentById(0x1020002);
        }
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            this.bindActionBarExtras(actionBar);
        }
    }

    private void bindActionBarExtras(ActionBar actionBar) {
        String subtitle;
        String title = this.resolveStringFromExtras(EXTRA_TITLE);
        if (title != null) {
            actionBar.setTitle((CharSequence)title);
        }
        if ((subtitle = this.resolveStringFromExtras(EXTRA_SUBTITLE)) != null) {
            actionBar.setSubtitle((CharSequence)subtitle);
        }
        boolean showHomeAsUp = this.getIntent().getBooleanExtra(EXTRA_HOME_AS_UP, false);
        actionBar.setDisplayHomeAsUpEnabled(showHomeAsUp);
    }

    private String resolveStringFromExtras(String identifier) {
        Object title = this.getIntent().getExtras().get(identifier);
        if (title instanceof String) {
            return (String)title;
        }
        if (title instanceof Integer) {
            return this.getString((Integer)title);
        }
        return null;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (!this.mFragment.onBackPressed()) {
            super.onBackPressed();
        }
    }

    public static class Builder {
        private Intent mIntent;

        private Builder(@NonNull Context context, WebViewSettings settings) {
            this.mIntent = new Intent(context, A3WebActivity.class);
            this.mIntent.putExtra(A3WebActivity.EXTRA_SETTINGS, (Parcelable)settings);
        }

        public Builder setTitle(@StringRes int title) {
            this.mIntent.putExtra(A3WebActivity.EXTRA_TITLE, title);
            return this;
        }

        public Builder setTitle(@NonNull String title) {
            this.mIntent.putExtra(A3WebActivity.EXTRA_TITLE, title);
            return this;
        }

        public Builder setSubtitle(@StringRes int subtitle) {
            this.mIntent.putExtra(A3WebActivity.EXTRA_SUBTITLE, subtitle);
            return this;
        }

        public Builder setSubtitle(@NonNull String subtitle) {
            this.mIntent.putExtra(A3WebActivity.EXTRA_SUBTITLE, subtitle);
            return this;
        }

        public Builder enableHomeAsUp() {
            this.mIntent.putExtra(A3WebActivity.EXTRA_HOME_AS_UP, true);
            return this;
        }

        public Intent build() {
            return this.mIntent;
        }
    }
}

