/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class MethodNode {
    public int access;
    public String name;
    public String desc;
    public final List exceptions;
    public final List instructions;
    public final List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public final List localVariables;
    public final List lineNumbers;

    public MethodNode(int n, String string, String string2, String[] stringArray) {
        this.access = n;
        this.name = string;
        this.desc = string2;
        this.exceptions = new ArrayList();
        this.instructions = new ArrayList();
        this.tryCatchBlocks = new ArrayList();
        this.localVariables = new ArrayList();
        this.lineNumbers = new ArrayList();
        if (stringArray != null) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        CodeVisitor codeVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, stringArray);
        if (codeVisitor != null && this.instructions.size() > 0) {
            int n = 0;
            while (n < this.instructions.size()) {
                Object e = this.instructions.get(n);
                if (e instanceof Label) {
                    codeVisitor.visitLabel((Label)e);
                } else {
                    ((AbstractInsnNode)e).accept(codeVisitor);
                }
                ++n;
            }
            n = 0;
            while (n < this.tryCatchBlocks.size()) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(n)).accept(codeVisitor);
                ++n;
            }
            codeVisitor.visitMaxs(this.maxStack, this.maxLocals);
            n = 0;
            while (n < this.localVariables.size()) {
                ((LocalVariableNode)this.localVariables.get(n)).accept(codeVisitor);
                ++n;
            }
            n = 0;
            while (n < this.lineNumbers.size()) {
                ((LineNumberNode)this.lineNumbers.get(n)).accept(codeVisitor);
                ++n;
            }
        }
    }
}

