/*
 * Decompiled with CFR 0.152.
 */
package arte.programar.materialfile.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import arte.programar.materialfile.R;
import arte.programar.materialfile.ui.OnItemClickListener;
import arte.programar.materialfile.utils.FileTypeUtils;
import java.io.File;
import java.util.List;

class DirectoryAdapter
extends RecyclerView.Adapter<DirectoryViewHolder> {
    private final List<File> mFiles;
    private OnItemClickListener mOnItemClickListener;

    DirectoryAdapter(List<File> files) {
        this.mFiles = files;
    }

    void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    @NonNull
    public DirectoryViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_file, parent, false);
        return new DirectoryViewHolder(view, this.mOnItemClickListener);
    }

    public void onBindViewHolder(DirectoryViewHolder holder, int position) {
        File currentFile = this.mFiles.get(position);
        FileTypeUtils.FileType fileType = FileTypeUtils.getFileType(currentFile);
        holder.mFileImage.setImageResource(fileType.getIcon());
        holder.mFileSubtitle.setText(fileType.getDescription());
        holder.mFileTitle.setText((CharSequence)currentFile.getName());
    }

    public int getItemCount() {
        return this.mFiles.size();
    }

    File getModel(int index) {
        return this.mFiles.get(index);
    }

    static class DirectoryViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mFileImage;
        private TextView mFileTitle;
        private TextView mFileSubtitle;

        DirectoryViewHolder(View itemView, OnItemClickListener clickListener) {
            super(itemView);
            itemView.setOnClickListener(v -> clickListener.onItemClick(v, this.getAdapterPosition()));
            this.mFileImage = (ImageView)itemView.findViewById(R.id.item_file_image);
            this.mFileTitle = (TextView)itemView.findViewById(R.id.item_file_title);
            this.mFileSubtitle = (TextView)itemView.findViewById(R.id.item_file_subtitle);
        }
    }
}

