/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.apt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.apt.AnnotationVisitor;
import org.kohsuke.args4j.apt.AnnotationVisitorReorderer;
import org.kohsuke.args4j.apt.HtmlWriter;
import org.kohsuke.args4j.apt.OptionWithUsage;
import org.kohsuke.args4j.apt.TxtWriter;
import org.kohsuke.args4j.apt.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessorImpl
extends AbstractProcessor {
    private File outDir = new File(System.getProperty("args4j.outdir"));
    private String format = System.getProperty("args4j.format");
    private Properties resource = null;
    private Types typeUtils;
    private Messager messenger;

    public AnnotationProcessorImpl() {
        String res = System.getProperty("args4j.resource");
        if (res != null && res.length() > 0) {
            try {
                this.resource = new Properties();
                this.resource.load(new FileInputStream(res));
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.messenger = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(Option.class.getName(), Argument.class.getName()));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private AnnotationVisitor createAnnotationVisitor(TypeElement te) throws IOException {
        FileWriter out = new FileWriter(new File(this.outDir, te.getQualifiedName() + "." + this.format.toLowerCase()));
        AnnotationVisitor writer = this.format.equals("XML") ? new XmlWriter(out, te) : (this.format.equals("TXT") ? new TxtWriter(out, te) : new HtmlWriter(out));
        return new AnnotationVisitorReorderer(writer);
    }

    private void scan(TypeElement decl, AnnotationVisitor visitor) {
        while (decl != null) {
            for (Element element : decl.getEnclosedElements()) {
                this.scan(element, visitor);
            }
            decl = (TypeElement)this.typeUtils.asElement(decl.getSuperclass());
        }
        visitor.done();
    }

    private void scan(Element f, AnnotationVisitor visitor) {
        Option o = f.getAnnotation(Option.class);
        if (o == null) {
            return;
        }
        String usage = this.getUsage(o);
        if (this.isOptionHidden(usage)) {
            return;
        }
        visitor.onOption(new OptionWithUsage(o, usage));
    }

    private boolean isOptionHidden(String usage) {
        return usage == null || usage.length() == 0;
    }

    private String getUsage(Option o) {
        if (this.resource == null) {
            return o.usage();
        }
        return this.resource.getProperty(o.usage());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> params = roundEnv.getElementsAnnotatedWith(Option.class);
        final HashSet optionBeans = new HashSet();
        for (Element element : params) {
            element.accept(new SimpleElementVisitor6<Void, Void>(){

                @Override
                public Void visitVariable(VariableElement e, Void p) {
                    TypeElement dt = (TypeElement)e.getEnclosingElement();
                    optionBeans.add(dt);
                    return null;
                }

                @Override
                public Void visitExecutable(ExecutableElement m, Void p) {
                    optionBeans.add((TypeElement)m.getEnclosingElement());
                    return null;
                }
            }, null);
        }
        for (TypeElement typeElement : optionBeans) {
            if (typeElement.getKind().isClass()) {
                try {
                    AnnotationVisitor writer = this.createAnnotationVisitor(typeElement);
                    this.messenger.printMessage(Diagnostic.Kind.NOTE, "Processing " + typeElement.getQualifiedName());
                    this.scan(typeElement, writer);
                }
                catch (IOException e) {
                    this.messenger.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                }
                continue;
            }
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "args4j annotations need to be placed on a class", typeElement);
        }
        return true;
    }
}

