/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.entities.columns;

import ar.com.fdvs.dj.core.DJException;
import ar.com.fdvs.dj.domain.constants.ImageScaleMode;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.util.ExpressionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageColumn
extends ExpressionColumn {
    private static final long serialVersionUID = 10000L;
    private static final Log log = LogFactory.getLog(ImageColumn.class);
    private ImageScaleMode scaleMode = ImageScaleMode.FILL_PROPORTIONALLY;

    public ImageScaleMode getScaleMode() {
        return this.scaleMode;
    }

    public void setScaleMode(ImageScaleMode scaleMode) {
        this.scaleMode = scaleMode;
    }

    @Override
    public String getValueClassNameForExpression() {
        if (this.getExpression() != null) {
            return this.getExpression().getClassName();
        }
        if (this.getColumnProperty() != null) {
            return this.getColumnProperty().getValueClassName();
        }
        return Object.class.getName();
    }

    @Override
    public String getTextForExpression() {
        if (this.getExpression() != null) {
            if (this.getCalculatedExpressionText() != null) {
                return this.getCalculatedExpressionText();
            }
            String stringExpression = ExpressionUtils.createCustomExpressionInvocationText(this.getExpression(), this.getColumnProperty().getProperty());
            log.debug((Object)("Image Column Expression for CustomExpression = " + stringExpression));
            this.setCalculatedExpressionText(stringExpression);
            return stringExpression;
        }
        if (this.getColumnProperty() != null) {
            return "$F{" + this.getColumnProperty().getProperty() + "}";
        }
        throw new DJException("Neither a CustomExpression or a ColumnProperty was set for colulm \"" + this.getName() + "\"");
    }
}

