/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.CoreException;
import ar.com.fdvs.dj.core.FontHelper;
import ar.com.fdvs.dj.core.layout.AbstractLayoutManager;
import ar.com.fdvs.dj.core.layout.CommonExpressionsHelper;
import ar.com.fdvs.dj.core.layout.Dj2JrCrosstabBuilder;
import ar.com.fdvs.dj.core.layout.HorizontalBandAlignment;
import ar.com.fdvs.dj.domain.AutoText;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DJLabel;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReportOptions;
import ar.com.fdvs.dj.domain.ImageBanner;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.SubreportParameter;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.GlobalGroupColumn;
import ar.com.fdvs.dj.domain.entities.columns.PercentageColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.util.ExpressionUtils;
import ar.com.fdvs.dj.util.LayoutUtils;
import ar.com.fdvs.dj.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignBreak;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignSubreportParameter;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassicLayoutManager
extends AbstractLayoutManager {
    protected static final String PAGE_BREAK_FOR_ = "pageBreak_for_";
    protected static final int SUBREPORT_DEFAULT_HEIGHT = 30;
    private static final Log log = LogFactory.getLog(ClassicLayoutManager.class);
    protected static final String EXPRESSION_TRUE_WHEN_NOT_FIRST_PAGE = "new java.lang.Boolean(((Number)$V{PAGE_NUMBER}).doubleValue() != 1)";
    protected static final String EXPRESSION_TRUE_WHEN_FIRST_PAGE = "new java.lang.Boolean(((Number)$V{PAGE_NUMBER}).doubleValue() == 1)";
    protected final Map referencesMap = new HashMap();

    @Override
    public Map getReferencesMap() {
        return this.referencesMap;
    }

    @Override
    protected void startLayout() {
        super.startLayout();
        this.generateTitleBand();
        this.generateHeaderBand();
        this.applyHeaderAutotexts();
        if (this.getReport().getColumnsGroups() != null) {
            this.layoutGroups();
        }
    }

    protected void applyHeaderAutotexts() {
        if (this.getReport().getAutoTexts() == null) {
            return;
        }
        JRDesignBand headerband = (JRDesignBand)this.getDesign().getPageHeader();
        if (headerband == null) {
            headerband = new JRDesignBand();
            this.getDesign().setPageHeader((JRBand)headerband);
        }
        ArrayList<HorizontalBandAlignment> positions = new ArrayList<HorizontalBandAlignment>();
        positions.add(HorizontalBandAlignment.LEFT);
        positions.add(HorizontalBandAlignment.CENTER);
        positions.add(HorizontalBandAlignment.RIGHT);
        ArrayList autotexts = new ArrayList(this.getReport().getAutoTexts());
        Collections.reverse(autotexts);
        int totalYoffset = this.findTotalOffset(positions, (byte)1);
        LayoutUtils.moveBandsElemnts(totalYoffset, headerband);
        for (Object e : positions) {
            HorizontalBandAlignment currentAlignment = (HorizontalBandAlignment)e;
            int yOffset = 0;
            for (Object o : this.getReport().getAutoTexts()) {
                AutoText text = (AutoText)o;
                if (text.getPosition() != 1 || !text.getAlignment().equals(currentAlignment)) continue;
                CommonExpressionsHelper.add(yOffset, (DynamicJasperDesign)this.getDesign(), this, headerband, text);
                yOffset += text.getHeight().intValue();
            }
        }
    }

    protected int findTotalOffset(ArrayList aligments, byte position) {
        int total = 0;
        for (Object aligment : aligments) {
            HorizontalBandAlignment currentAlignment = (HorizontalBandAlignment)aligment;
            int aux = 0;
            for (Object o : this.getReport().getAutoTexts()) {
                AutoText autotext = (AutoText)o;
                if (autotext.getPosition() != position || !currentAlignment.equals(autotext.getAlignment())) continue;
                aux += autotext.getHeight().intValue();
            }
            if (aux <= total) continue;
            total = aux;
        }
        return total;
    }

    @Override
    protected void endLayout() {
        super.endLayout();
        this.applyBanners();
        this.applyFooterAutotexts();
        this.applyFooterBanners();
        this.setBandsFinalHeight();
    }

    protected void applyFooterAutotexts() {
        if (this.getReport().getAutoTexts() == null) {
            return;
        }
        JRDesignBand footerband = (JRDesignBand)this.getDesign().getPageFooter();
        if (footerband == null) {
            footerband = new JRDesignBand();
            this.getDesign().setPageFooter((JRBand)footerband);
        }
        ArrayList<HorizontalBandAlignment> positions = new ArrayList<HorizontalBandAlignment>();
        positions.add(HorizontalBandAlignment.LEFT);
        positions.add(HorizontalBandAlignment.CENTER);
        positions.add(HorizontalBandAlignment.RIGHT);
        for (Object e : positions) {
            HorizontalBandAlignment currentAlignment = (HorizontalBandAlignment)e;
            int yOffset = 0;
            for (Object o : this.getReport().getAutoTexts()) {
                AutoText autotext = (AutoText)o;
                if (autotext.getPosition() != 0 || !autotext.getAlignment().equals(currentAlignment)) continue;
                CommonExpressionsHelper.add(yOffset, (DynamicJasperDesign)this.getDesign(), this, footerband, autotext);
                yOffset += autotext.getHeight().intValue();
            }
        }
    }

    protected List getVisibleColumns() {
        ArrayList<AbstractColumn> visibleColums = new ArrayList<AbstractColumn>(this.getReport().getColumns());
        for (Object o : this.getReport().getColumnsGroups()) {
            DJGroup group = (DJGroup)o;
            if (!group.getLayout().isHideColumn()) continue;
            visibleColums.remove(group.getColumnToGroupBy());
        }
        return visibleColums;
    }

    protected void applyBanners() {
        DynamicReportOptions options = this.getReport().getOptions();
        if (options.getFirstPageImageBanners().isEmpty() && options.getImageBanners().isEmpty()) {
            return;
        }
        JRDesignBand title = (JRDesignBand)this.getDesign().getTitle();
        if (title == null && !options.getFirstPageImageBanners().isEmpty()) {
            title = new JRDesignBand();
            this.getDesign().setTitle((JRBand)title);
        }
        this.applyImageBannersToBand(title, options.getFirstPageImageBanners().values(), null, true);
        JRDesignBand pageHeader = (JRDesignBand)this.getDesign().getPageHeader();
        if (pageHeader == null && !options.getImageBanners().isEmpty()) {
            pageHeader = new JRDesignBand();
            this.getDesign().setPageHeader((JRBand)pageHeader);
        }
        JRDesignExpression printWhenExpression = null;
        if (!options.getFirstPageImageBanners().isEmpty()) {
            printWhenExpression = new JRDesignExpression();
            printWhenExpression.setValueClass(Boolean.class);
            printWhenExpression.setText(EXPRESSION_TRUE_WHEN_NOT_FIRST_PAGE);
        }
        this.applyImageBannersToBand(pageHeader, options.getImageBanners().values(), printWhenExpression, true);
    }

    protected void applyFooterBanners() {
        JRDesignBand pageFooter = (JRDesignBand)this.getDesign().getPageFooter();
        if (pageFooter == null) {
            pageFooter = new JRDesignBand();
            this.getDesign().setPageFooter((JRBand)pageFooter);
        }
        this.applyImageBannersToBand(pageFooter, this.getReport().getOptions().getFooterImageBanners().values(), null, false);
    }

    protected void applyImageBannersToBand(JRDesignBand band, Collection imageBanners, JRDesignExpression printWhenExpression, boolean placeOnTop) {
        int maxHeight = 0;
        if (placeOnTop) {
            for (Object imageBanner1 : imageBanners) {
                ImageBanner imageBanner = (ImageBanner)imageBanner1;
                if (imageBanner.getHeight() <= maxHeight) continue;
                maxHeight = imageBanner.getHeight();
            }
        } else {
            maxHeight = LayoutUtils.findVerticalOffset(band);
        }
        if (band != null) {
            if (placeOnTop) {
                for (JRChild jrChild : band.getChildren()) {
                    JRDesignElement element = (JRDesignElement)jrChild;
                    element.setY(element.getY() + maxHeight);
                }
            }
            int yPosition = 0;
            if (!placeOnTop) {
                yPosition = maxHeight + 1;
            }
            for (Object imageBanner1 : imageBanners) {
                ImageBanner imageBanner = (ImageBanner)imageBanner1;
                String path = "\"" + imageBanner.getImagePath().replaceAll("\\\\", "/") + "\"";
                JRDesignImage image = new JRDesignImage(new JRDesignStyle().getDefaultStyleProvider());
                JRDesignExpression imageExp = new JRDesignExpression();
                imageExp.setText(path);
                imageExp.setValueClass(String.class);
                image.setExpression((JRExpression)imageExp);
                image.setHeight(imageBanner.getHeight());
                image.setWidth(imageBanner.getWidth());
                image.setPrintWhenExpression((JRExpression)printWhenExpression);
                image.setRemoveLineWhenBlank(true);
                image.setScaleImage(ScaleImageEnum.getByValue((byte)imageBanner.getScaleMode().getValue()));
                if (imageBanner.getAlign() == 0) {
                    image.setX(0);
                } else if (imageBanner.getAlign() == 1) {
                    image.setX(this.getReport().getOptions().getPage().getWidth() - this.getReport().getOptions().getLeftMargin() - this.getReport().getOptions().getRightMargin() - imageBanner.getWidth());
                } else if (imageBanner.getAlign() == 2) {
                    int x = (this.getReport().getOptions().getPage().getWidth() - this.getReport().getOptions().getRightMargin() - this.getReport().getOptions().getLeftMargin() - imageBanner.getWidth()) / 2;
                    image.setX(this.getReport().getOptions().getLeftMargin() + x);
                }
                image.setY(yPosition);
                band.addElement((JRDesignElement)image);
            }
            band.setHeight(band.getHeight() + maxHeight);
        }
    }

    protected void generateTitleBand() {
        log.debug((Object)"Generating title band...");
        JRDesignBand band = (JRDesignBand)this.getDesign().getPageHeader();
        int yOffset = 0;
        if (this.getReport().getTitle() == null) {
            return;
        }
        if (band != null && !this.getDesign().isTitleNewPage()) {
            yOffset = band.getHeight();
        } else {
            band = (JRDesignBand)this.getDesign().getTitle();
            if (band == null) {
                band = new JRDesignBand();
                this.getDesign().setTitle((JRBand)band);
            }
        }
        JRDesignExpression printWhenExpression = new JRDesignExpression();
        printWhenExpression.setValueClass(Boolean.class);
        printWhenExpression.setText(EXPRESSION_TRUE_WHEN_FIRST_PAGE);
        JRDesignTextField title = new JRDesignTextField();
        JRDesignExpression exp = new JRDesignExpression();
        if (this.getReport().isTitleIsJrExpression()) {
            exp.setText(this.getReport().getTitle());
        } else {
            exp.setText("\"" + Utils.escapeTextForExpression(this.getReport().getTitle()) + "\"");
        }
        exp.setValueClass(String.class);
        title.setExpression((JRExpression)exp);
        title.setWidth(this.getReport().getOptions().getPrintableWidth());
        title.setHeight(this.getReport().getOptions().getTitleHeight().intValue());
        title.setY(yOffset);
        title.setPrintWhenExpression((JRExpression)printWhenExpression);
        title.setRemoveLineWhenBlank(true);
        this.applyStyleToElement(this.getReport().getTitleStyle(), (JRDesignElement)title);
        title.setStretchType(StretchTypeEnum.NO_STRETCH);
        band.addElement((JRDesignElement)title);
        JRDesignTextField subtitle = new JRDesignTextField();
        if (this.getReport().getSubtitle() != null) {
            JRDesignExpression exp2 = new JRDesignExpression();
            exp2.setText("\"" + this.getReport().getSubtitle() + "\"");
            exp2.setValueClass(String.class);
            subtitle.setExpression((JRExpression)exp2);
            subtitle.setWidth(this.getReport().getOptions().getPrintableWidth());
            subtitle.setHeight(this.getReport().getOptions().getSubtitleHeight().intValue());
            subtitle.setY(title.getY() + title.getHeight());
            subtitle.setPrintWhenExpression((JRExpression)printWhenExpression);
            subtitle.setRemoveLineWhenBlank(true);
            this.applyStyleToElement(this.getReport().getSubtitleStyle(), (JRDesignElement)subtitle);
            title.setStretchType(StretchTypeEnum.NO_STRETCH);
            band.addElement((JRDesignElement)subtitle);
        }
    }

    protected void layoutGroups() {
        log.debug((Object)"Starting groups layout...");
        for (Object o1 : this.getReport().getColumnsGroups()) {
            DJGroupLabel label;
            DJGroup columnsGroup = (DJGroup)o1;
            JRDesignGroup jgroup = this.getJRGroupFromDJGroup(columnsGroup);
            jgroup.setStartNewPage(columnsGroup.getStartInNewPage().booleanValue());
            jgroup.setStartNewColumn(columnsGroup.getStartInNewColumn().booleanValue());
            jgroup.setReprintHeaderOnEachPage(columnsGroup.isReprintHeaderOnEachPage());
            jgroup.setResetPageNumber(columnsGroup.isResetPageNumber());
            JRDesignSection headerSection = (JRDesignSection)jgroup.getGroupHeaderSection();
            JRDesignSection footerSection = (JRDesignSection)jgroup.getGroupFooterSection();
            JRDesignBand header = LayoutUtils.getBandFromSection(headerSection);
            JRDesignBand footer = LayoutUtils.getBandFromSection(footerSection);
            if (header == null) {
                header = new JRDesignBand();
                headerSection.addBand((JRBand)header);
            }
            if (footer == null) {
                footer = new JRDesignBand();
                footerSection.addBand((JRBand)footer);
            }
            header.setHeight(columnsGroup.getHeaderHeight().intValue());
            footer.setHeight(columnsGroup.getFooterHeight().intValue());
            header.setSplitType(LayoutUtils.getSplitTypeFromBoolean(columnsGroup.isAllowHeaderSplit()));
            footer.setSplitType(LayoutUtils.getSplitTypeFromBoolean(columnsGroup.isAllowFooterSplit()));
            if (columnsGroup.getLayout().isPrintHeaders()) {
                Object prevG;
                boolean found = false;
                boolean skipPreviousGroupHeaders = false;
                int groupIdx = this.getReport().getColumnsGroups().indexOf(columnsGroup);
                if (groupIdx > 0 && !(((DJGroup)(prevG = (DJGroup)this.getReport().getColumnsGroups().get(groupIdx - 1))).getColumnToGroupBy() instanceof GlobalGroupColumn)) {
                    skipPreviousGroupHeaders = !((DJGroup)prevG).getLayout().isShowValueForEachRow();
                }
                prevG = this.getVisibleColumns().iterator();
                while (prevG.hasNext()) {
                    Object o = prevG.next();
                    AbstractColumn col = (AbstractColumn)o;
                    if (col.equals(columnsGroup.getColumnToGroupBy())) {
                        found = true;
                    }
                    if (!found && skipPreviousGroupHeaders) continue;
                    JRDesignTextField designTextField = this.createColumnNameTextField(columnsGroup, col);
                    designTextField.setPositionType(PositionTypeEnum.FLOAT);
                    designTextField.setStretchType(StretchTypeEnum.NO_STRETCH);
                    header.addElement((JRDesignElement)designTextField);
                }
            }
            if ((label = columnsGroup.getFooterLabel()) != null) {
                List footerVariables = columnsGroup.getFooterVariables();
                PropertyColumn col = columnsGroup.getColumnToGroupBy();
                int x = 0;
                int y = 0;
                int width = this.getDesign().getPageWidth() - this.getDesign().getLeftMargin() - this.getDesign().getRightMargin();
                int height = label.getHeight();
                int yOffset = 0;
                if (label.getLabelPosition() == LabelPosition.LEFT) {
                    DJGroupVariable lmvar = this.findLeftMostColumn(footerVariables);
                    x = col.getPosX();
                    y = this.findYOffsetForGroupLabel(footer);
                    if (lmvar != null) {
                        AbstractColumn lmColumn = lmvar.getColumnToApplyOperation();
                        width = lmColumn.getPosX() - x;
                    } else {
                        width -= x;
                    }
                    height = this.getFooterVariableHeight(columnsGroup);
                } else if (label.getLabelPosition() == LabelPosition.RIGHT) {
                    DJGroupVariable rmvar = this.findRightMostColumn(footerVariables);
                    if (rmvar != null) {
                        AbstractColumn rmColumn = rmvar.getColumnToApplyOperation();
                        x = rmColumn.getPosX() + rmColumn.getWidth();
                    } else {
                        x = col.getPosX();
                    }
                    y = this.findYOffsetForGroupLabel(footer);
                    width -= x;
                    height = this.getFooterVariableHeight(columnsGroup);
                } else if (label.getLabelPosition() == LabelPosition.TOP) {
                    x = col.getPosX();
                    width -= x;
                    yOffset = height;
                } else if (label.getLabelPosition() == LabelPosition.BOTTOM) {
                    x = col.getPosX();
                    y = this.getFooterVariableHeight(columnsGroup);
                    width -= x;
                }
                this.layoutGroupFooterLabels(columnsGroup, jgroup, x, y, width, height);
                this.layoutGroupVariables(columnsGroup, jgroup, yOffset);
            } else {
                this.layoutGroupVariables(columnsGroup, jgroup, 0);
            }
            this.layoutGroupSubreports(columnsGroup, jgroup);
            this.layoutGroupCrosstabs(columnsGroup, jgroup);
        }
    }

    protected void layoutGroupFooterLabels(DJGroup djgroup, JRDesignGroup jgroup, int x, int y, int width, int height) {
        DJGroupLabel label = djgroup.getFooterLabel();
        JRDesignBand band = LayoutUtils.getBandFromSection((JRDesignSection)jgroup.getGroupFooterSection());
        JRDesignExpression labelExp = label.isJasperExpression() ? ExpressionUtils.createStringExpression(label.getText()) : (label.getLabelExpression() != null ? ExpressionUtils.createExpression(jgroup.getName() + "_labelExpression", label.getLabelExpression(), true) : ExpressionUtils.createStringExpression("\"" + label.getText() + "\""));
        JRDesignTextField labelTf = new JRDesignTextField();
        labelTf.setExpression((JRExpression)labelExp);
        labelTf.setWidth(width);
        labelTf.setHeight(height);
        labelTf.setX(x);
        labelTf.setY(y);
        labelTf.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
        this.applyStyleToElement(label.getStyle(), (JRDesignElement)labelTf);
        band.addElement((JRDesignElement)labelTf);
    }

    private int findYOffsetForGroupLabel(JRDesignBand band) {
        int offset = 0;
        for (JRChild jrChild : band.getChildren()) {
            JRDesignElement elem = (JRDesignElement)jrChild;
            if (elem.getKey() == null || !elem.getKey().startsWith("variable_for_column_")) continue;
            offset = elem.getY();
            break;
        }
        return offset;
    }

    protected void layoutGroupCrosstabs(DJGroup columnsGroup, JRDesignGroup jgroup) {
        JRDesignRectangle rect;
        JRDesignBand band;
        JRDesignCrosstab crosst;
        Dj2JrCrosstabBuilder djcb;
        DJCrosstab djcross;
        for (Object o1 : columnsGroup.getHeaderCrosstabs()) {
            djcross = (DJCrosstab)o1;
            djcb = new Dj2JrCrosstabBuilder();
            crosst = djcb.createCrosstab(djcross, this);
            band = LayoutUtils.getBandFromSection((JRDesignSection)jgroup.getGroupHeaderSection());
            if (djcross.getBottomSpace() != 0) {
                JRDesignRectangle rect2 = this.createBlankRectableCrosstab(djcross.getBottomSpace(), 0);
                LayoutUtils.moveBandsElemnts(rect2.getHeight(), band);
                band.addElement((JRDesignElement)rect2);
            }
            LayoutUtils.moveBandsElemnts(crosst.getHeight(), band);
            band.addElement((JRDesignElement)crosst);
            DJLabel caption = djcross.getCaption();
            if (caption != null) {
                JRDesignExpression captExp;
                if (caption.isJasperExpression()) {
                    captExp = ExpressionUtils.createStringExpression(caption.getText());
                } else if (caption.getLabelExpression() != null) {
                    String name = "expression_for_label_at_header_of_group[" + this.getReport().getColumnsGroups().indexOf(columnsGroup) + "]_crosstab[" + columnsGroup.getHeaderCrosstabs().indexOf(djcross) + "]";
                    LayoutUtils.registerCustomExpressionParameter((DynamicJasperDesign)this.getDesign(), name, caption.getLabelExpression());
                    String invocationText = ExpressionUtils.createCustomExpressionInvocationText(caption.getLabelExpression(), name, false);
                    captExp = ExpressionUtils.createExpression(invocationText, caption.getLabelExpression().getClassName());
                    log.debug((Object)invocationText);
                } else {
                    captExp = ExpressionUtils.createStringExpression("\"" + Utils.escapeTextForExpression(caption.getText()) + "\"");
                }
                JRDesignTextField captTf = new JRDesignTextField();
                captTf.setExpression((JRExpression)captExp);
                captTf.setHeight(caption.getHeight());
                captTf.setWidth(this.getReport().getOptions().getPrintableWidth());
                LayoutUtils.moveBandsElemnts(caption.getHeight(), band);
                band.addElement((JRDesignElement)captTf);
            }
            if (djcross.getTopSpace() == 0) continue;
            LayoutUtils.moveBandsElemnts(djcross.getTopSpace(), band);
            rect = this.createBlankRectableCrosstab(djcross.getBottomSpace(), 0);
            band.addElement((JRDesignElement)rect);
        }
        for (Object o : columnsGroup.getFooterCrosstabs()) {
            djcross = (DJCrosstab)o;
            djcb = new Dj2JrCrosstabBuilder();
            crosst = djcb.createCrosstab(djcross, this);
            band = LayoutUtils.getBandFromSection((JRDesignSection)jgroup.getGroupFooterSection());
            int yOffset = LayoutUtils.findVerticalOffset(band);
            if (djcross.getTopSpace() != 0) {
                rect = this.createBlankRectableCrosstab(djcross.getBottomSpace(), yOffset);
                rect.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
                band.addElement((JRDesignElement)rect);
                crosst.setY(rect.getY() + rect.getHeight());
            }
            band.addElement((JRDesignElement)crosst);
            if (djcross.getBottomSpace() == 0) continue;
            rect = this.createBlankRectableCrosstab(djcross.getBottomSpace(), crosst.getY() + crosst.getHeight());
            band.addElement((JRDesignElement)rect);
        }
    }

    protected JRDesignRectangle createBlankRectableCrosstab(int amount, int yOffset) {
        JRDesignRectangle rect = new JRDesignRectangle();
        LayoutUtils.convertBorderToPen(Border.NO_BORDER(), rect.getLinePen());
        rect.setMode(ModeEnum.getByValue((byte)Transparency.TRANSPARENT.getValue()));
        rect.setWidth(this.getReport().getOptions().getPrintableWidth());
        rect.setHeight(amount);
        rect.setY(yOffset);
        rect.setPositionType(PositionTypeEnum.FLOAT);
        return rect;
    }

    protected JRDesignTextField createColumnNameTextField(DJGroup columnsGroup, AbstractColumn col) {
        JRDesignTextField designStaticText = new JRDesignTextField();
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("\"" + col.getTitle() + "\"");
        exp.setValueClass(String.class);
        designStaticText.setExpression((JRExpression)exp);
        designStaticText.setHeight(columnsGroup.getHeaderHeight().intValue());
        designStaticText.setWidth(col.getWidth().intValue());
        designStaticText.setX(col.getPosX().intValue());
        designStaticText.setY(col.getPosY().intValue());
        Style headerStyle = columnsGroup.getColumnHeaderStyle(col);
        if (headerStyle == null) {
            headerStyle = columnsGroup.getDefaultColumnHeaederStyle();
        }
        if (headerStyle == null) {
            headerStyle = col.getHeaderStyle();
        }
        this.applyStyleToElement(headerStyle, (JRDesignElement)designStaticText);
        return designStaticText;
    }

    protected void layoutGroupSubreports(DJGroup columnsGroup, JRDesignGroup jgroup) {
        log.debug((Object)"Starting subreport layout...");
        JRDesignBand footerBand = (JRDesignBand)((JRDesignSection)jgroup.getGroupFooterSection()).getBandsList().get(0);
        JRDesignBand headerBand = (JRDesignBand)((JRDesignSection)jgroup.getGroupHeaderSection()).getBandsList().get(0);
        this.layOutSubReportInBand(columnsGroup, headerBand, "header");
        this.layOutSubReportInBand(columnsGroup, footerBand, "footer");
    }

    protected void layOutSubReportInBand(DJGroup columnsGroup, JRDesignBand band, String position) {
        List subreportsList = "footer".equals(position) ? columnsGroup.getFooterSubreports() : columnsGroup.getHeaderSubreports();
        for (Object aSubreportsList : subreportsList) {
            JRDesignExpression connectionExpression;
            Subreport sr = (Subreport)aSubreportsList;
            JRDesignSubreport subreport = new JRDesignSubreport(new JRDesignStyle().getDefaultStyleProvider());
            int dataSourceOrigin = sr.getDatasource().getDataSourceOrigin();
            if (10 == dataSourceOrigin) {
                connectionExpression = ExpressionUtils.getReportConnectionExpression();
                subreport.setConnectionExpression((JRExpression)connectionExpression);
            } else if (100 == sr.getDatasource().getDataSourceType()) {
                connectionExpression = ExpressionUtils.getConnectionExpression(sr.getDatasource());
                subreport.setConnectionExpression((JRExpression)connectionExpression);
            } else {
                JRDesignExpression dataSourceExpression = ExpressionUtils.getDataSourceExpression(sr.getDatasource());
                subreport.setDataSourceExpression((JRExpression)dataSourceExpression);
            }
            String paramname = sr.getName();
            ((DynamicJasperDesign)this.getDesign()).getParametersWithValues().put(paramname, sr.getReport());
            String expText = "(" + JasperReport.class.getName() + ")$P{REPORT_PARAMETERS_MAP}.get( \"" + paramname + "\" )";
            JRDesignExpression srExpression = ExpressionUtils.createExpression(expText, JasperReport.class);
            subreport.setExpression((JRExpression)srExpression);
            subreport.setParametersMapExpression((JRExpression)ExpressionUtils.getParameterExpression(sr));
            for (Object o : sr.getParameters()) {
                SubreportParameter srparam = (SubreportParameter)o;
                JRDesignSubreportParameter subreportParameter = new JRDesignSubreportParameter();
                subreportParameter.setName(srparam.getName());
                JRDesignExpression expression2 = ExpressionUtils.createExpression(this.getDesign(), srparam);
                subreportParameter.setExpression((JRExpression)expression2);
                try {
                    subreport.addParameter((JRSubreportParameter)subreportParameter);
                }
                catch (JRException e) {
                    log.error((Object)"Error registering parameter for subreport, there must be another parameter with the same name");
                    throw new CoreException(e.getMessage(), e);
                }
            }
            int offset = LayoutUtils.findVerticalOffset(band);
            subreport.setY(offset);
            subreport.setX(-this.getReport().getOptions().getLeftMargin().intValue());
            subreport.setWidth(this.getReport().getOptions().getPage().getWidth());
            subreport.setHeight(30);
            subreport.setPositionType(PositionTypeEnum.FLOAT);
            subreport.setStretchType(StretchTypeEnum.NO_STRETCH);
            subreport.setRemoveLineWhenBlank(true);
            band.setHeight(offset + subreport.getHeight());
            if (sr.getStyle() != null) {
                this.applyStyleToElement(sr.getStyle(), (JRDesignElement)subreport);
            }
            if (sr.isStartInNewPage()) {
                JRDesignGroup jrgroup = this.getJRGroupFromDJGroup(columnsGroup);
                JRDesignBand targetBand = null;
                int idx = this.getDesign().getGroupsList().indexOf(jrgroup);
                if (!"header".equals(position)) {
                    if (idx + 1 < this.getDesign().getGroupsList().size()) {
                        ++idx;
                    }
                    JRDesignGroup jrGroup = (JRDesignGroup)this.getDesign().getGroupsList().get(idx);
                    targetBand = LayoutUtils.getBandFromSection((JRDesignSection)jrGroup.getGroupFooterSection());
                }
                if ("footer".equals(position) && targetBand != null) {
                    JRDesignBreak pageBreak = new JRDesignBreak(new JRDesignStyle().getDefaultStyleProvider());
                    pageBreak.setKey(PAGE_BREAK_FOR_ + jrgroup.toString());
                    pageBreak.setY(0);
                    pageBreak.setPositionType(PositionTypeEnum.FLOAT);
                    targetBand.addElement((JRDesignElement)pageBreak);
                }
            }
            band.addElement((JRDesignElement)subreport);
            this.sendPageBreakToBottom(band);
            band.setSplitType(LayoutUtils.getSplitTypeFromBoolean(sr.isSplitAllowed()));
        }
    }

    protected void sendPageBreakToBottom(JRDesignBand band) {
        JRElement[] elems = band.getElements();
        JRElement aux = null;
        for (JRElement elem : elems) {
            if (!("" + elem.getKey()).startsWith(PAGE_BREAK_FOR_)) continue;
            aux = elem;
            break;
        }
        if (aux != null) {
            ((JRDesignElement)aux).setY(band.getHeight());
        }
    }

    protected void layoutGroupVariables(DJGroup group, JRDesignGroup jgroup, int labelOffset) {
        Integer height;
        JRDesignSection footerSection;
        JRDesignBand footerBand;
        log.debug((Object)"Starting groups variables layout...");
        JRDesignSection headerSection = (JRDesignSection)jgroup.getGroupHeaderSection();
        JRDesignBand headerBand = (JRDesignBand)headerSection.getBandsList().get(0);
        if (headerBand == null) {
            headerBand = new JRDesignBand();
            headerSection.addBand((JRBand)headerBand);
        }
        if ((footerBand = (JRDesignBand)(footerSection = (JRDesignSection)jgroup.getGroupFooterSection()).getBandsList().get(0)) == null) {
            footerBand = new JRDesignBand();
            footerSection.addBand((JRBand)footerBand);
        }
        int headerOffset = 0;
        int yOffset = 0;
        GroupLayout layout = group.getLayout();
        PropertyColumn column = group.getColumnToGroupBy();
        Integer n = height = group.getHeaderVariablesHeight() != null ? group.getHeaderVariablesHeight() : this.getReport().getOptions().getDetailHeight();
        if (layout.isShowValueInHeader() && layout.isHideColumn() && !layout.isShowColumnName()) {
            JRDesignTextField currentValue = this.generateTextFieldFromColumn(column, height, group);
            currentValue.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
            int headerVariablesWidth = this.getReport().getOptions().getPrintableWidth();
            if (!group.getHeaderVariables().isEmpty()) {
                DJGroupVariable leftmostcol = this.findLeftMostColumn(group.getHeaderVariables());
                headerVariablesWidth = leftmostcol.getColumnToApplyOperation().getPosX();
                if (this.groupLabelsPresent(group.getHeaderVariables())) {
                    currentValue.setY(height.intValue());
                    currentValue.setHeight(this.getHeaderVariablesHeight(group));
                }
            }
            currentValue.setWidth(headerVariablesWidth);
            LayoutUtils.moveBandsElemnts((yOffset += currentValue.getHeight()) - 1, headerBand);
            if (group.getLayout().isPrintHeaders()) {
                headerOffset += group.getHeaderHeight() + this.getReport().getOptions().getDetailHeight();
            }
            headerBand.addElement((JRDesignElement)currentValue);
        } else if (layout.isShowValueInHeader() && !layout.isHideColumn() && !layout.isShowColumnName()) {
            headerOffset = this.changeHeaderBandHeightForVariables(headerBand, group);
            this.insertValueInHeader(headerBand, group, headerOffset);
        } else if (layout.isShowValueInHeader() && layout.isHideColumn() && layout.isShowColumnName()) {
            JRDesignTextField columnNameTf = this.createColumnNameTextField(group, column);
            columnNameTf.setY(columnNameTf.getY() + headerOffset);
            JRDesignTextField currentValue = this.generateTextFieldFromColumn(column, height, group);
            currentValue.setWidth(this.getReport().getOptions().getPrintableWidth() - columnNameTf.getWidth());
            currentValue.setX(columnNameTf.getWidth());
            if (column.getStyle() != null && column.getStyle().getFont() != null) {
                currentValue.setHeight(FontHelper.getHeightFor(column.getStyle().getFont()));
            }
            columnNameTf.setHeight(currentValue.getHeight());
            LayoutUtils.moveBandsElemnts(yOffset += currentValue.getHeight(), headerBand);
            headerBand.addElement((JRDesignElement)columnNameTf);
            headerBand.addElement((JRDesignElement)currentValue);
        }
        this.placeVariableInBand(group.getHeaderVariables(), group, jgroup, "header", headerBand, headerOffset);
        this.placeVariableInBand(group.getFooterVariables(), group, jgroup, "footer", footerBand, labelOffset);
    }

    protected boolean groupLabelsPresent(List groupVariables) {
        for (Object groupVariable : groupVariables) {
            DJGroupVariable var = (DJGroupVariable)groupVariable;
            if (var.getLabel() == null) continue;
            return true;
        }
        return false;
    }

    protected void placeVariableInBand(List variables, DJGroup djGroup, JRDesignGroup jgroup, String type, JRDesignBand band, int yOffset) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        boolean inFooter = "footer".equals(type);
        log.debug((Object)("Placing variables in " + type + " band for group " + djGroup.getColumnToGroupBy().getTextForExpression()));
        int height = inFooter ? this.getFooterVariableHeight(djGroup) : this.getHeaderVariablesHeight(djGroup);
        Iterator it = variables.iterator();
        int yOffsetGlabel = 0;
        while (it.hasNext()) {
            Style defStyle;
            DJGroupVariable var = (DJGroupVariable)it.next();
            AbstractColumn col = var.getColumnToApplyOperation();
            String variableName = var.getName();
            DJGroupLabel label = var.getLabel();
            JRDesignTextField labelTf = null;
            if (label != null) {
                JRDesignExpression labelExp = label.isJasperExpression() ? ExpressionUtils.createStringExpression(label.getText()) : (label.getLabelExpression() != null ? ExpressionUtils.createExpression(variableName + "_labelExpression", label.getLabelExpression(), false) : ExpressionUtils.createStringExpression("\"" + label.getText() + "\""));
                labelTf = new JRDesignTextField();
                labelTf.setExpression((JRExpression)labelExp);
                labelTf.setWidth(col.getWidth().intValue());
                labelTf.setHeight(label.getHeight());
                labelTf.setX(col.getPosX().intValue());
                labelTf.setY(yOffset);
                yOffsetGlabel = labelTf.getHeight();
                if (inFooter) {
                    labelTf.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
                }
                this.applyStyleToElement(label.getStyle(), (JRDesignElement)labelTf);
                band.addElement((JRDesignElement)labelTf);
            }
            JRDesignExpression expression = new JRDesignExpression();
            JRDesignTextField textField = new JRDesignTextField();
            if (inFooter) {
                textField.setEvaluationTime(EvaluationTimeEnum.NOW);
            } else {
                textField.setEvaluationTime(EvaluationTimeEnum.GROUP);
            }
            if (var.getValueExpression() != null) {
                expression = ExpressionUtils.createExpression(variableName + "_valueExpression", var.getValueExpression(), false);
            } else {
                this.setTextAndClassToExpression(expression, var, col, variableName);
            }
            if (var.getOperation() != DJCalculation.COUNT && var.getOperation() != DJCalculation.DISTINCT_COUNT) {
                textField.setPattern(col.getPattern());
            }
            if (col instanceof PercentageColumn) {
                PercentageColumn pcol = (PercentageColumn)col;
                expression.setText(pcol.getTextForExpression(djGroup, djGroup, type));
                expression.setValueClassName(pcol.getValueClassNameForExpression());
                textField.setEvaluationTime(EvaluationTimeEnum.AUTO);
            } else {
                textField.setEvaluationGroup((JRGroup)jgroup);
            }
            textField.setKey(variableName);
            textField.setExpression((JRExpression)expression);
            if (inFooter) {
                textField.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
            }
            textField.setX(col.getPosX().intValue());
            textField.setY(yOffset + yOffsetGlabel);
            textField.setHeight(height);
            textField.setWidth(col.getWidth().intValue());
            textField.setKey("variable_for_column_" + this.getVisibleColumns().indexOf(col) + "_in_group_" + this.getDesign().getGroupsList().indexOf(jgroup));
            Style style = defStyle = "header".equals(type) ? djGroup.getDefaulHeaderVariableStyle() : djGroup.getDefaulFooterVariableStyle();
            if (var.getStyle() != null) {
                this.applyStyleToElement(var.getStyle(), (JRDesignElement)textField);
            } else if (col.getStyle() != null) {
                Style style2 = col.getStyle();
                try {
                    style2 = (Style)style2.clone();
                    style2.setName(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.applyStyleToElement(style2, (JRDesignElement)textField);
            } else if (defStyle != null) {
                this.applyStyleToElement(defStyle, (JRDesignElement)textField);
            }
            if (var.getPrintWhenExpression() != null) {
                JRDesignExpression exp = ExpressionUtils.createExpression(variableName + "_printWhenExpression", var.getPrintWhenExpression(), false);
                textField.setPrintWhenExpression((JRExpression)exp);
                if (labelTf != null) {
                    labelTf.setPrintWhenExpression((JRExpression)exp);
                }
            }
            band.addElement((JRDesignElement)textField);
        }
        if (djGroup.getColumnToGroupBy() instanceof GlobalGroupColumn) {
            DJGroupVariable leftmostColumn = this.findLeftMostColumn(variables);
            int totalWidth = leftmostColumn.getColumnToApplyOperation().getPosX();
            GlobalGroupColumn globalCol = (GlobalGroupColumn)djGroup.getColumnToGroupBy();
            JRDesignTextField globalTextField = new JRDesignTextField();
            JRDesignExpression globalExp = new JRDesignExpression();
            globalExp.setText(globalCol.getTextForExpression());
            globalExp.setValueClassName(globalCol.getValueClassNameForExpression());
            globalTextField.setExpression((JRExpression)globalExp);
            globalTextField.setHeight(height);
            globalTextField.setWidth(totalWidth);
            globalTextField.setX(0);
            if (type.equals("header")) {
                globalTextField.setY(yOffset);
            }
            globalTextField.setKey("global_legend_" + type);
            this.applyStyleToElement(globalCol.getStyle(), (JRDesignElement)globalTextField);
            band.addElement((JRDesignElement)globalTextField);
        }
    }

    protected int getHeaderVariablesHeight(DJGroup columnsGroup) {
        Integer height = columnsGroup.getHeaderVariablesHeight() != null ? columnsGroup.getHeaderVariablesHeight() : DynamicReportOptions.DEFAULT_HEADER_VARIABLES_HEIGHT;
        return height;
    }

    protected int getFooterVariableHeight(DJGroup columnsGroup) {
        Integer height = columnsGroup.getFooterVariablesHeight() != null ? columnsGroup.getFooterVariablesHeight() : DynamicReportOptions.DEFAULT_FOOTER_VARIABLES_HEIGHT;
        return height;
    }

    protected void setTextAndClassToExpression(JRDesignExpression expression, DJGroupVariable var, AbstractColumn col, String variableName) {
        if (var.getValueFormatter() != null) {
            expression.setText(var.getTextForValueFormatterExpression(variableName));
            expression.setValueClassName(var.getValueFormatter().getClassName());
        } else if (col.getTextFormatter() != null) {
            expression.setText("$V{" + variableName + "}");
            expression.setValueClassName(col.getVariableClassName(var.getOperation()));
        } else {
            expression.setText("$V{" + variableName + "}");
            expression.setValueClassName(col.getVariableClassName(var.getOperation()));
        }
    }

    protected DJGroupVariable findLeftMostColumn(List variables) {
        int mostLeftX = Integer.MAX_VALUE;
        DJGroupVariable mostLeftColumn = null;
        for (Object variable : variables) {
            DJGroupVariable currentCol = (DJGroupVariable)variable;
            if (currentCol.getColumnToApplyOperation().getPosX() > mostLeftX) continue;
            mostLeftColumn = currentCol;
            mostLeftX = mostLeftColumn.getColumnToApplyOperation().getPosX();
        }
        return mostLeftColumn;
    }

    protected DJGroupVariable findRightMostColumn(List variables) {
        int mostRightX = Integer.MIN_VALUE;
        DJGroupVariable mostRightColumn = null;
        for (Object variable : variables) {
            DJGroupVariable currentCol = (DJGroupVariable)variable;
            if (currentCol.getColumnToApplyOperation().getPosX() < mostRightX) continue;
            mostRightColumn = currentCol;
            mostRightX = mostRightColumn.getColumnToApplyOperation().getPosX();
        }
        return mostRightColumn;
    }

    protected void insertValueInHeader(JRDesignBand headerBand, DJGroup djgroup, int headerOffset) {
        int height = this.getReport().getOptions().getDetailHeight();
        if (!djgroup.getHeaderVariables().isEmpty()) {
            height = djgroup.getHeaderVariablesHeight() != null ? djgroup.getHeaderVariablesHeight() : this.getReport().getOptions().getDetailHeight();
        }
        JRDesignTextField textField = this.generateTextFieldFromColumn(djgroup.getColumnToGroupBy(), height, djgroup);
        textField.setStretchType(StretchTypeEnum.NO_STRETCH);
        textField.setY(textField.getY() + headerOffset);
        headerBand.addElement((JRDesignElement)textField);
    }

    protected int changeHeaderBandHeightForVariables(JRDesignBand headerBand, DJGroup columnsGroup) {
        int result = 0;
        if (!headerBand.getChildren().isEmpty()) {
            int acu = headerBand.getHeight();
            headerBand.setHeight(headerBand.getHeight() + columnsGroup.getHeaderHeight());
            result = acu;
        } else {
            headerBand.setHeight(this.getReport().getOptions().getHeaderVariablesHeight().intValue());
        }
        return result;
    }

    protected void generateHeaderBand() {
        log.debug((Object)"Generating main report header band.");
        JRDesignBand header = (JRDesignBand)this.getDesign().getColumnHeader();
        if (header == null) {
            header = new JRDesignBand();
            this.getDesign().setColumnHeader((JRBand)header);
        }
        if (this.getReport().getOptions().isPrintColumnNames()) {
            this.generateHeaderBand(header);
        }
    }

    @Override
    protected void transformDetailBandTextField(AbstractColumn column, JRDesignTextField textField) {
        DJGroup group = this.getDJGroup(column);
        if (group != null && !group.getLayout().isShowValueForEachRow()) {
            textField.setExpression(null);
        }
    }
}

