/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.layout.AbstractLayoutManager;
import ar.com.fdvs.dj.core.layout.CrossTabColorShema;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJCrosstabColumn;
import ar.com.fdvs.dj.domain.DJCrosstabMeasure;
import ar.com.fdvs.dj.domain.DJCrosstabRow;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.util.ExpressionUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Dj2JrCrosstabBuilder {
    private static final Log log = LogFactory.getLog((Class)Dj2JrCrosstabBuilder.class);
    private JasperDesign design;
    private JRDesignCrosstab jrcross;
    private DJCrosstab djcross;
    private DJCrosstabColumn[] cols;
    private DJCrosstabRow[] rows;
    private Color[][] colors;
    private AbstractLayoutManager layoutManager;

    public JRDesignCrosstab createCrosstab(DJCrosstab djcrosstab, AbstractLayoutManager layoutManager) {
        this.djcross = djcrosstab;
        this.layoutManager = layoutManager;
        this.design = layoutManager.getDesign();
        this.jrcross = new JRDesignCrosstab();
        this.jrcross.setPositionType((byte)2);
        this.cols = djcrosstab.getColumns().toArray(new DJCrosstabColumn[0]);
        this.rows = djcrosstab.getRows().toArray(new DJCrosstabRow[0]);
        this.initColors();
        this.setCrosstabOptions();
        this.registerColumns();
        this.registerRows();
        this.registerMeasures();
        this.createCells();
        this.createMainHeaderCell();
        this.registerDataSet(djcrosstab);
        return this.jrcross;
    }

    private void setCrosstabOptions() {
        if (this.djcross.isUseFullWidth()) {
            this.jrcross.setWidth(this.layoutManager.getReport().getOptions().getPrintableWidth());
        } else {
            this.jrcross.setWidth(this.djcross.getWidth());
        }
        this.jrcross.setHeight(this.djcross.getHeight());
        this.jrcross.setColumnBreakOffset(this.djcross.getColumnBreakOffset());
    }

    private void createMainHeaderCell() {
        JRDesignCellContents contents = new JRDesignCellContents();
        contents.setBackcolor(this.colors[this.colors.length - 1][this.colors[0].length - 1]);
        contents.setMode(new Byte(Transparency.OPAQUE.getValue()));
        this.jrcross.setHeaderCell(contents);
        JRDesignTextField element = new JRDesignTextField();
        String text = "";
        int auxHeight = 0;
        int auxWidth = 0;
        if (this.djcross.isAutomaticTitle()) {
            text = this.createAutomaticMainHeaderTitle();
        } else if (this.djcross.getMainHeaderTitle() != null) {
            text = "\"" + this.djcross.getMainHeaderTitle() + "\"";
        }
        Iterator iterator = this.djcross.getColumns().iterator();
        while (iterator.hasNext()) {
            DJCrosstabColumn col = (DJCrosstabColumn)iterator.next();
            auxHeight += col.getHeaderHeight();
        }
        iterator = this.djcross.getRows().iterator();
        while (iterator.hasNext()) {
            DJCrosstabRow row = (DJCrosstabRow)iterator.next();
            auxWidth += row.getHeaderWidth();
        }
        JRDesignExpression exp = ExpressionUtils.createStringExpression(text);
        element.setExpression((JRExpression)exp);
        element.setWidth(auxWidth);
        element.setHeight(auxHeight);
        element.setStretchWithOverflow(true);
        if (this.djcross.getHeaderStyle() != null) {
            this.layoutManager.applyStyleToElement(this.djcross.getHeaderStyle(), (JRDesignElement)element);
        }
        this.applyCellBorder(contents);
        contents.addElement((JRDesignElement)element);
    }

    private String createAutomaticMainHeaderTitle() {
        String text = "";
        Iterator iterator = this.djcross.getColumns().iterator();
        while (iterator.hasNext()) {
            DJCrosstabColumn col = (DJCrosstabColumn)iterator.next();
            text = text + col.getTitle();
            if (!iterator.hasNext()) continue;
            text = text + ", ";
        }
        text = text + "\\nvs.\\n";
        iterator = this.djcross.getRows().iterator();
        while (iterator.hasNext()) {
            DJCrosstabRow row = (DJCrosstabRow)iterator.next();
            text = text + row.getTitle();
            if (!iterator.hasNext()) continue;
            text = text + ", ";
        }
        text = "\"" + text + "\"";
        return text;
    }

    private void initColors() {
        this.colors = CrossTabColorShema.createSchema(this.djcross.getColorScheme(), this.cols.length, this.rows.length);
    }

    private void registerDataSet(DJCrosstab djcrosstab) {
        JRDesignField field;
        int i;
        JRDesignCrosstabDataset dataset = new JRDesignCrosstabDataset();
        dataset.setDataPreSorted(djcrosstab.getDatasource().isPreSorted());
        JRDesignDatasetRun datasetRun = new JRDesignDatasetRun();
        JRDesignExpression exp = ExpressionUtils.getDataSourceExpression(djcrosstab.getDatasource());
        datasetRun.setDataSourceExpression((JRExpression)exp);
        dataset.setDatasetRun((JRDatasetRun)datasetRun);
        JRDesignDataset jrDataset = new JRDesignDataset(false);
        for (i = this.rows.length - 1; i >= 0; --i) {
            DJCrosstabRow crosstabRow = this.rows[i];
            field = new JRDesignField();
            field.setName(crosstabRow.getProperty().getProperty());
            field.setValueClassName(crosstabRow.getProperty().getValueClassName());
            try {
                jrDataset.addField((JRField)field);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (i = this.cols.length - 1; i >= 0; --i) {
            DJCrosstabColumn crosstabColumn = this.cols[i];
            field = new JRDesignField();
            field.setName(crosstabColumn.getProperty().getProperty());
            field.setValueClassName(crosstabColumn.getProperty().getValueClassName());
            try {
                jrDataset.addField((JRField)field);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        JRDesignField field2 = new JRDesignField();
        field2.setName(djcrosstab.getMeasure(0).getProperty().getProperty());
        field2.setValueClassName(djcrosstab.getMeasure(0).getProperty().getValueClassName());
        try {
            jrDataset.addField((JRField)field2);
        }
        catch (JRException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.jrcross.setDataset(dataset);
        Random rd = new Random();
        String dsName = "crosstabDataSource_" + rd.nextLong();
        while (this.design.getDatasetMap().containsKey(dsName)) {
            dsName = "crosstabDataSource_" + rd.nextLong();
        }
        datasetRun.setDatasetName(dsName);
        jrDataset.setName(dsName);
        log.debug((Object)("Crosstab dataset name = " + dsName));
        try {
            if (!this.design.getDatasetMap().containsKey(jrDataset.getName())) {
                this.design.addDataset(jrDataset);
            }
        }
        catch (JRException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void createCells() {
        DJCrosstabColumn auxCol = new DJCrosstabColumn();
        DJCrosstabRow auxRow = new DJCrosstabRow();
        try {
            BeanUtils.copyProperties((Object)auxCol, this.djcross.getColumns().get(this.djcross.getColumns().size() - 1));
            BeanUtils.copyProperties((Object)auxRow, this.djcross.getRows().get(this.djcross.getRows().size() - 1));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        auxCol.setProperty(null);
        auxRow.setProperty(null);
        ArrayList<DJCrosstabColumn> auxColsList = new ArrayList<DJCrosstabColumn>(this.djcross.getColumns());
        auxColsList.add(auxCol);
        ArrayList<DJCrosstabRow> auxRowsList = new ArrayList<DJCrosstabRow>(this.djcross.getRows());
        auxRowsList.add(auxRow);
        DJCrosstabColumn[] auxCols = auxColsList.toArray(new DJCrosstabColumn[0]);
        DJCrosstabRow[] auxRows = auxRowsList.toArray(new DJCrosstabRow[0]);
        for (int i = auxCols.length - 1; i >= 0; --i) {
            for (int j = auxRows.length - 1; j >= 0; --j) {
                DJCrosstabColumn crosstabColumn = auxCols[i];
                DJCrosstabRow crosstabRow = auxRows[j];
                JRDesignCrosstabCell cell = new JRDesignCrosstabCell();
                cell.setWidth(new Integer(crosstabColumn.getWidth()));
                cell.setHeight(new Integer(crosstabRow.getHeight()));
                if (crosstabColumn.getProperty() != null) {
                    cell.setColumnTotalGroup(crosstabColumn.getProperty().getProperty());
                }
                if (crosstabRow.getProperty() != null) {
                    cell.setRowTotalGroup(crosstabRow.getProperty().getProperty());
                }
                JRDesignCellContents contents = new JRDesignCellContents();
                JRDesignTextField element = new JRDesignTextField();
                element.setWidth(crosstabColumn.getWidth());
                element.setHeight(crosstabRow.getHeight());
                JRDesignExpression measureExp = new JRDesignExpression();
                DJCrosstabMeasure measure = this.djcross.getMeasure(0);
                measureExp.setValueClassName(measure.getProperty().getValueClassName());
                measureExp.setText("$V{" + measure.getProperty().getProperty() + "}");
                element.setExpression((JRExpression)measureExp);
                if (crosstabRow.getProperty() == null && crosstabColumn.getProperty() == null && measure.getStyle() != null) {
                    this.layoutManager.applyStyleToElement(measure.getStyle(), (JRDesignElement)element);
                } else if (crosstabRow.getTotalStyle() != null) {
                    this.layoutManager.applyStyleToElement(crosstabRow.getTotalStyle(), (JRDesignElement)element);
                } else if (crosstabColumn.getTotalStyle() != null) {
                    this.layoutManager.applyStyleToElement(crosstabColumn.getTotalStyle(), (JRDesignElement)element);
                }
                contents.setMode(new Byte(Transparency.OPAQUE.getValue()));
                contents.setBackcolor(this.colors[i][j]);
                contents.addElement((JRDesignElement)element);
                this.applyCellBorder(contents);
                cell.setContents(contents);
                try {
                    this.jrcross.addCell(cell);
                    continue;
                }
                catch (JRException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void registerMeasures() {
        Iterator iterator = this.djcross.getMeasures().iterator();
        while (iterator.hasNext()) {
            DJCrosstabMeasure djmeasure = (DJCrosstabMeasure)iterator.next();
            JRDesignCrosstabMeasure measure = new JRDesignCrosstabMeasure();
            measure.setName(djmeasure.getProperty().getProperty());
            measure.setCalculation(djmeasure.getOperation().getValue());
            measure.setValueClassName(djmeasure.getProperty().getValueClassName());
            JRDesignExpression valueExp = new JRDesignExpression();
            valueExp.setValueClassName(djmeasure.getProperty().getValueClassName());
            valueExp.setText("$F{" + djmeasure.getProperty().getProperty() + "}");
            measure.setValueExpression((JRExpression)valueExp);
            try {
                this.jrcross.addMeasure(measure);
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void registerRows() {
        for (int i = 0; i < this.rows.length; ++i) {
            DJCrosstabRow crosstabRow = this.rows[i];
            JRDesignCrosstabRowGroup ctRowGroup = new JRDesignCrosstabRowGroup();
            ctRowGroup.setWidth(crosstabRow.getHeaderWidth());
            ctRowGroup.setName(crosstabRow.getProperty().getProperty());
            JRDesignCrosstabBucket rowBucket = new JRDesignCrosstabBucket();
            ctRowGroup.setBucket(rowBucket);
            JRDesignExpression bucketExp = ExpressionUtils.createExpression("$F{" + crosstabRow.getProperty().getProperty() + "}", crosstabRow.getProperty().getValueClassName());
            rowBucket.setExpression(bucketExp);
            JRDesignCellContents rowHeaderContents = new JRDesignCellContents();
            JRDesignTextField rowTitle = new JRDesignTextField();
            JRDesignExpression rowTitExp = new JRDesignExpression();
            rowTitExp.setValueClassName(crosstabRow.getProperty().getValueClassName());
            rowTitExp.setText("$V{" + crosstabRow.getProperty().getProperty() + "}");
            rowTitle.setExpression((JRExpression)rowTitExp);
            rowTitle.setWidth(crosstabRow.getHeaderWidth());
            int auxHeight = this.getRowHeaderMaxHeight(crosstabRow);
            rowTitle.setHeight(auxHeight);
            if (crosstabRow.getHeaderStyle() != null) {
                this.layoutManager.applyStyleToElement(crosstabRow.getHeaderStyle(), (JRDesignElement)rowTitle);
            }
            rowHeaderContents.addElement((JRDesignElement)rowTitle);
            rowHeaderContents.setBackcolor(this.colors[this.cols.length - 1][i]);
            rowHeaderContents.setMode(new Byte(Transparency.OPAQUE.getValue()));
            this.applyCellBorder(rowHeaderContents);
            ctRowGroup.setHeader(rowHeaderContents);
            if (crosstabRow.isShowTotals()) {
                this.createRowTotalHeader(ctRowGroup, crosstabRow);
            }
            try {
                this.jrcross.addRowGroup(ctRowGroup);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private int getRowHeaderMaxHeight(DJCrosstabRow crosstabRow) {
        int auxHeight = crosstabRow.getHeight();
        boolean found = false;
        Iterator iterator = this.djcross.getRows().iterator();
        while (iterator.hasNext()) {
            DJCrosstabRow row = (DJCrosstabRow)iterator.next();
            if (!row.equals(crosstabRow) && !found) continue;
            found = true;
            if (row.equals(crosstabRow) || !row.isShowTotals()) continue;
            auxHeight += row.getHeight();
        }
        return auxHeight;
    }

    private void registerColumns() {
        for (int i = 0; i < this.cols.length; ++i) {
            DJCrosstabColumn crosstabColumn = this.cols[i];
            JRDesignCrosstabColumnGroup ctColGroup = new JRDesignCrosstabColumnGroup();
            ctColGroup.setName(crosstabColumn.getProperty().getProperty());
            ctColGroup.setHeight(crosstabColumn.getHeaderHeight());
            JRDesignCrosstabBucket bucket = new JRDesignCrosstabBucket();
            JRDesignExpression bucketExp = ExpressionUtils.createExpression("$F{" + crosstabColumn.getProperty().getProperty() + "}", crosstabColumn.getProperty().getValueClassName());
            bucket.setExpression(bucketExp);
            ctColGroup.setBucket(bucket);
            JRDesignCellContents colHeaerContent = new JRDesignCellContents();
            JRDesignTextField colTitle = new JRDesignTextField();
            JRDesignExpression colTitleExp = new JRDesignExpression();
            colTitleExp.setValueClassName(crosstabColumn.getProperty().getValueClassName());
            colTitleExp.setText("$V{" + crosstabColumn.getProperty().getProperty() + "}");
            colTitle.setExpression((JRExpression)colTitleExp);
            colTitle.setWidth(crosstabColumn.getWidth());
            colTitle.setHeight(crosstabColumn.getHeaderHeight());
            int auxWidth = this.calculateRowHeaderMaxWidth(crosstabColumn);
            colTitle.setWidth(auxWidth);
            if (crosstabColumn.getHeaderStyle() != null) {
                this.layoutManager.applyStyleToElement(crosstabColumn.getHeaderStyle(), (JRDesignElement)colTitle);
            }
            colHeaerContent.addElement((JRDesignElement)colTitle);
            colHeaerContent.setBackcolor(this.colors[i][this.rows.length - 1]);
            colHeaerContent.setMode(new Byte(Transparency.OPAQUE.getValue()));
            this.applyCellBorder(colHeaerContent);
            ctColGroup.setHeader(colHeaerContent);
            if (crosstabColumn.isShowTotals()) {
                this.createColumTotalHeader(ctColGroup, crosstabColumn);
            }
            try {
                this.jrcross.addColumnGroup(ctColGroup);
                continue;
            }
            catch (JRException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private int calculateRowHeaderMaxWidth(DJCrosstabColumn crosstabColumn) {
        int auxWidth = 0;
        boolean firstTime = true;
        ArrayList auxList = new ArrayList(this.djcross.getColumns());
        Collections.reverse(auxList);
        Iterator iterator = auxList.iterator();
        while (iterator.hasNext()) {
            DJCrosstabColumn col = (DJCrosstabColumn)iterator.next();
            if (col.equals(crosstabColumn)) {
                if (auxWidth != 0) break;
                auxWidth = col.getWidth();
                break;
            }
            if (firstTime) {
                auxWidth += col.getWidth();
                firstTime = false;
            }
            if (!col.isShowTotals()) continue;
            auxWidth += col.getWidth();
        }
        return auxWidth;
    }

    private void createRowTotalHeader(JRDesignCrosstabRowGroup ctRowGroup, DJCrosstabRow crosstabRow) {
        JRDesignCellContents totalHeaderContent = new JRDesignCellContents();
        ctRowGroup.setTotalHeader(totalHeaderContent);
        ctRowGroup.setTotalPosition((byte)2);
        totalHeaderContent.setBackcolor(this.colors[this.colors.length / 2][0]);
        totalHeaderContent.setMode(new Byte(Transparency.OPAQUE.getValue()));
        JRDesignTextField element = new JRDesignTextField();
        JRDesignExpression exp = ExpressionUtils.createExpression("\"Total " + crosstabRow.getTitle() + "\"", String.class);
        element.setExpression((JRExpression)exp);
        element.setHeight(crosstabRow.getHeight());
        if (crosstabRow.getTotalHeaderStyle() != null) {
            this.layoutManager.applyStyleToElement(crosstabRow.getTotalHeaderStyle(), (JRDesignElement)element);
        }
        int auxWidth = 0;
        boolean found = false;
        Iterator iterator = this.djcross.getRows().iterator();
        while (iterator.hasNext()) {
            DJCrosstabRow row = (DJCrosstabRow)iterator.next();
            if (!row.equals(crosstabRow) && !found) continue;
            found = true;
            auxWidth += row.getHeaderWidth();
        }
        element.setWidth(auxWidth);
        this.applyCellBorder(totalHeaderContent);
        totalHeaderContent.addElement((JRDesignElement)element);
    }

    private void applyCellBorder(JRDesignCellContents cellContent) {
        if (this.djcross.getCellBorder() != null && !this.djcross.getCellBorder().equals(Border.NO_BORDER)) {
            JRBaseBox box = new JRBaseBox();
            box.setBottomBorder(this.djcross.getCellBorder().getValue());
            box.setRightBorder(this.djcross.getCellBorder().getValue());
            box.setBorderColor(Color.black);
            cellContent.setBox((JRBox)box);
        }
    }

    private void createColumTotalHeader(JRDesignCrosstabColumnGroup ctColGroup, DJCrosstabColumn crosstabColumn) {
        JRDesignCellContents totalHeaderContent = new JRDesignCellContents();
        ctColGroup.setTotalHeader(totalHeaderContent);
        ctColGroup.setTotalPosition((byte)2);
        totalHeaderContent.setBackcolor(this.colors[this.colors.length / 2][this.colors[0].length / 2]);
        totalHeaderContent.setMode(new Byte(Transparency.OPAQUE.getValue()));
        JRDesignExpression exp = ExpressionUtils.createExpression("\"Total " + crosstabColumn.getTitle() + "\"", String.class);
        JRDesignTextField element = new JRDesignTextField();
        element.setExpression((JRExpression)exp);
        element.setWidth(crosstabColumn.getWidth());
        if (crosstabColumn.getTotalHeaderStyle() != null) {
            this.layoutManager.applyStyleToElement(crosstabColumn.getTotalHeaderStyle(), (JRDesignElement)element);
        }
        int auxWidth = 0;
        boolean found = false;
        Iterator iterator = this.djcross.getColumns().iterator();
        while (iterator.hasNext()) {
            DJCrosstabColumn col = (DJCrosstabColumn)iterator.next();
            if (!col.equals(crosstabColumn) && !found) continue;
            found = true;
            auxWidth += col.getHeaderHeight();
        }
        element.setHeight(auxWidth);
        this.applyCellBorder(totalHeaderContent);
        totalHeaderContent.addElement((JRDesignElement)element);
    }
}

