/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.util.Iterator;

public class GroupBuilder {
    private DJGroup group = new DJGroup();
    private Style defaultFooterVariableStyle;
    private Style defaultHeaderVariableStyle;

    public DJGroup build() {
        DJGroupVariable var;
        Iterator iterator = this.group.getHeaderVariables().iterator();
        while (iterator.hasNext()) {
            var = (DJGroupVariable)iterator.next();
            if (this.defaultHeaderVariableStyle == null) continue;
            var.setStyle(this.defaultHeaderVariableStyle);
        }
        iterator = this.group.getFooterVariables().iterator();
        while (iterator.hasNext()) {
            var = (DJGroupVariable)iterator.next();
            if (this.defaultFooterVariableStyle == null) continue;
            var.setStyle(this.defaultFooterVariableStyle);
        }
        return this.group;
    }

    public GroupBuilder setCriteriaColumn(PropertyColumn column) {
        this.group.setColumnToGroupBy(column);
        return this;
    }

    public GroupBuilder addHeaderVariable(DJGroupVariable variable) {
        this.group.getHeaderVariables().add(variable);
        return this;
    }

    public GroupBuilder addHeaderVariable(AbstractColumn column, DJCalculation operation) {
        this.group.getHeaderVariables().add(new DJGroupVariable(column, operation));
        return this;
    }

    public GroupBuilder addHeaderVariable(AbstractColumn column, DJCalculation operation, Style style) {
        this.group.getHeaderVariables().add(new DJGroupVariable(column, operation, style));
        return this;
    }

    public GroupBuilder addFooterVariable(DJGroupVariable variable) {
        this.group.getFooterVariables().add(variable);
        return this;
    }

    public GroupBuilder addFooterVariable(AbstractColumn column3, DJCalculation operation) {
        this.group.getFooterVariables().add(new DJGroupVariable(column3, operation));
        return this;
    }

    public GroupBuilder addFooterVariable(AbstractColumn column3, DJCalculation operation, Style style) {
        this.group.getFooterVariables().add(new DJGroupVariable(column3, operation, style));
        return this;
    }

    public GroupBuilder setHeaderHeight(Integer height) {
        this.group.setHeaderHeight(height);
        return this;
    }

    public GroupBuilder setFooterHeight(Integer height) {
        this.group.setFooterHeight(height);
        return this;
    }

    public GroupBuilder setGroupLayout(GroupLayout layout) {
        this.group.setLayout(layout);
        return this;
    }

    public GroupBuilder setDefaultFooterVariableStyle(Style defaultFooterVariableStyle) {
        this.defaultFooterVariableStyle = defaultFooterVariableStyle;
        return this;
    }

    public GroupBuilder setDefaultHeaderVariableStyle(Style defaultHeaderVariableStyle) {
        this.defaultHeaderVariableStyle = defaultHeaderVariableStyle;
        return this;
    }

    public GroupBuilder addHeaderSubreport(Subreport subreport) {
        this.group.getHeaderSubreports().add(subreport);
        return this;
    }

    public GroupBuilder addFooterSubreport(Subreport subreport) {
        this.group.getFooterSubreports().add(subreport);
        return this;
    }

    public GroupBuilder setStartInNewPage(Boolean bool) {
        this.group.setStartInNewPage(bool);
        return this;
    }

    public GroupBuilder setStartInNewPage(boolean bool) {
        this.group.setStartInNewPage(bool);
        return this;
    }

    public GroupBuilder setStartInNewColumn(Boolean bool) {
        this.group.setStartInNewColumn(bool);
        return this;
    }

    public GroupBuilder setStartInNewColumn(boolean bool) {
        this.group.setStartInNewColumn(bool);
        return this;
    }

    public GroupBuilder addColumnHeaderStyle(AbstractColumn column, Style style) {
        this.group.addColumHeaderStyle(column, style);
        return this;
    }

    public GroupBuilder setDefaultColumnHeaderStyle(Style style) {
        this.group.setDefaultColumnHeaederStyle(style);
        return this;
    }

    public GroupBuilder setAllowHeaderSplit(boolean headerSplit) {
        this.group.setAllowHeaederSplit(headerSplit);
        return this;
    }

    public GroupBuilder setAllowFooterSplit(boolean footerSplit) {
        this.group.setAllowFooterSplit(footerSplit);
        return this;
    }

    public GroupBuilder setAllowSplitting(boolean headerSplit, boolean footerSplit) {
        this.group.setAllowHeaederSplit(headerSplit);
        this.group.setAllowFooterSplit(footerSplit);
        return this;
    }
}

