/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import net.sf.jasperreports.engine.design.JRDesignExpression;

public abstract class AutoTextExpressionUtils {
    private static final String PAGE_NUMBER_VAR = "$V{PAGE_NUMBER}";

    public static JRDesignExpression getPageNumberExpression(String before, String after, boolean useI18n) {
        JRDesignExpression expression = new JRDesignExpression();
        String text = null;
        if (useI18n) {
            before = !AutoTextExpressionUtils.emptyString(before) ? "$R{" + before + "}" : "\"" + before + "\"";
            after = !AutoTextExpressionUtils.emptyString(after) ? "$R{" + after + "}" : "\"" + after + "\"";
            text = before + "+\" \" + " + PAGE_NUMBER_VAR + "+\" \" + " + after;
        } else {
            before = AutoTextExpressionUtils.emptyString(before) ? "\"\"" : "\"" + before + "\"";
            after = AutoTextExpressionUtils.emptyString(after) ? "\"\"" : "\"" + after + "\"";
            text = before + "+\" \" + " + PAGE_NUMBER_VAR + "+\" \" + " + after;
        }
        expression.setText(text);
        expression.setValueClass(String.class);
        return expression;
    }

    private static boolean emptyString(String str) {
        if (str == null) {
            return true;
        }
        return "".equals(str.trim());
    }

    public static JRDesignExpression getDateExpression(String before, String after, Locale locale, byte pattern) {
        before = !AutoTextExpressionUtils.emptyString(before) ? "$R{" + before + "}" : "\"" + before + "\"";
        after = !AutoTextExpressionUtils.emptyString(after) ? "$R{" + after + "}" : "\"" + after + "\"";
        DateFormat dateFormatter = null;
        dateFormatter = 1 == pattern ? DateFormat.getDateInstance(2, locale) : (2 == pattern ? DateFormat.getTimeInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale));
        JRDesignExpression expression = new JRDesignExpression();
        String text = before + "+\" \" + \"" + dateFormatter.format(new Date()) + "\" +\" \" + " + after;
        expression.setText(text);
        expression.setValueClass(String.class);
        return expression;
    }
}

