/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.webwork;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.layout.ListLayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.output.FormatInfoRegistry;
import ar.com.fdvs.dj.output.ReportWriter;
import ar.com.fdvs.dj.output.ReportWriterFactory;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.views.jasperreports.JasperReportsResult;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DJResult
extends JasperReportsResult {
    private static final long serialVersionUID = -5135527859073133975L;
    private static final Log LOG = LogFactory.getLog((Class)DJResult.class);
    public static final String LAYOUT_CLASSIC = "classic";
    public static final String LAYOUT_LIST = "list";
    private String dynamicReport;
    private String documentFormat;
    private String layoutManager;

    public void setDynamicReport(String _dynamicReport) {
        this.dynamicReport = _dynamicReport;
    }

    protected void doExecute(String _finalLocation, ActionInvocation _invocation) throws Exception {
        this.checkParams();
        this.documentFormat = this.getFormat(_invocation);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating JasperReport for dynamicReport, format = " + this.documentFormat));
        }
        JRDataSource ds = (JRDataSource)this.conditionalParse(this.dataSource, _invocation, JRDataSource.class);
        HttpServletRequest request = (HttpServletRequest)_invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)_invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.dispatcher.HttpServletResponse");
        if ("contype".equals(request.getHeader("User-Agent"))) {
            this.handleConTypeRequest(response);
        } else {
            HashMap<String, Locale> parameters = new HashMap<String, Locale>();
            parameters.put("REPORT_LOCALE", _invocation.getInvocationContext().getLocale());
            LayoutManager layoutManagerObj = this.getLayOutManagerObj(_invocation);
            JasperPrint jasperPrint = DynamicJasperHelper.generateJasperPrint(this.getDynamicReport(_invocation), layoutManagerObj, ds, parameters);
            this.writeReponse(request, response, jasperPrint, _invocation);
        }
    }

    private LayoutManager getLayOutManagerObj(ActionInvocation _invocation) {
        String los = this.conditionalParse(this.layoutManager, _invocation);
        if (LAYOUT_CLASSIC.equals(los)) {
            return new ClassicLayoutManager();
        }
        if (LAYOUT_LIST.equals(los)) {
            return new ListLayoutManager();
        }
        LayoutManager lo = (LayoutManager)this.conditionalParse(this.layoutManager, _invocation, LayoutManager.class);
        if (lo != null) {
            return lo;
        }
        if (los != null) {
            try {
                lo = (LayoutManager)Class.forName(los).newInstance();
            }
            catch (Exception e) {
                LOG.warn((Object)("No valid LayoutManager: " + e.getMessage()), (Throwable)e);
            }
        }
        if (lo == null) {
            LOG.warn((Object)"No valid LayoutManager, using ClassicLayoutManager");
            lo = new ClassicLayoutManager();
        }
        return lo;
    }

    private void handleConTypeRequest(HttpServletResponse _response) throws ServletException {
        try {
            _response.setContentType("application/pdf");
            _response.setContentLength(0);
            _response.getOutputStream().close();
        }
        catch (IOException ex) {
            LOG.error((Object)"Error writing report output", (Throwable)ex);
            throw new ServletException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void checkParams() {
        if (this.dynamicReport == null) {
            String message = "No dynamicReport specified...";
            LOG.error((Object)"No dynamicReport specified...");
            throw new WebWorkException("No dynamicReport specified...");
        }
        if (this.dataSource == null) {
            String message = "No dataSource specified...";
            LOG.error((Object)"No dataSource specified...");
            throw new WebWorkException("No dataSource specified...");
        }
    }

    private void setResponseHeaders(HttpServletResponse _response, ActionInvocation _invocation) {
        if (this.contentDisposition != null || this.documentName != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getContentDisposition(_invocation));
            if (this.documentName != null) {
                buffer.append("; filename=");
                buffer.append(this.getDocumentName(_invocation));
                buffer.append(".");
                buffer.append(this.documentFormat.toLowerCase());
            }
            _response.setHeader("Content-disposition", buffer.toString());
        }
        _response.setContentType(FormatInfoRegistry.getInstance().getContentType(this.documentFormat));
    }

    private void writeReponse(HttpServletRequest _request, HttpServletResponse _response, JasperPrint _jasperPrint, ActionInvocation _invocation) throws JRException, IOException {
        this.setResponseHeaders(_response, _invocation);
        HashMap<JRHtmlExporterParameter, String> parameters = new HashMap<JRHtmlExporterParameter, String>();
        parameters.put(JRHtmlExporterParameter.IMAGES_URI, _request.getContextPath() + this.imageServletUrl);
        ReportWriter reportWriter = ReportWriterFactory.getInstance().getReportWriter(_jasperPrint, this.documentFormat, parameters);
        reportWriter.writeTo(_response);
    }

    private DynamicReport getDynamicReport(ActionInvocation _invocation) {
        return (DynamicReport)this.conditionalParse(this.dynamicReport, _invocation, DynamicReport.class);
    }

    private String getFormat(ActionInvocation _invocation) {
        String parsedFormat = this.conditionalParse(this.format == null ? "PDF" : this.format, _invocation);
        return TextUtils.stringSet((String)parsedFormat) ? parsedFormat : "PDF";
    }

    private String getDocumentName(ActionInvocation _invocation) {
        return this.conditionalParse(this.documentName, _invocation);
    }

    private String getContentDisposition(ActionInvocation _invocation) {
        String parsedContentDisposition = this.conditionalParse(this.contentDisposition, _invocation);
        return parsedContentDisposition == null ? "inline" : parsedContentDisposition;
    }

    private Object conditionalParse(String _param, ActionInvocation _invocation, Class _type) {
        if (this.parse && _param != null && _invocation != null) {
            return TextParseUtil.translateVariables((char)'$', (String)_param, (OgnlValueStack)_invocation.getStack(), (Class)_type, null);
        }
        return _param;
    }

    public String getLayoutManager() {
        return this.layoutManager;
    }

    public void setLayoutManager(String layoutManager) {
        this.layoutManager = layoutManager;
    }
}

