/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.elog.data;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import app.raybritton.elog.data.LogDatabase;
import app.raybritton.elog.data.LogFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0019J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0011H\u0002J\f\u0010\u001c\u001a\u00020\u0011*\u00020\u001dH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lapp/raybritton/elog/data/LogDatabase;", "", "()V", "openHelper", "Lapp/raybritton/elog/data/LogDatabase$LogDbOpenHelper;", "getOpenHelper", "()Lapp/raybritton/elog/data/LogDatabase$LogDbOpenHelper;", "openHelper$delegate", "Lkotlin/Lazy;", "deleteAll", "", "deleteAll$lib_release", "deleteLog", "id", "", "deleteLog$lib_release", "getLatestLog", "Lapp/raybritton/elog/data/LogFile;", "getLogs", "", "getLogs$lib_release", "insertLog", "logFile", "insertLog$lib_release", "updateLog", "updateLog$lib_release", "toContentValues", "Landroid/content/ContentValues;", "toLogFile", "Landroid/database/Cursor;", "Companion", "LogDbOpenHelper", "lib_release"})
public final class LogDatabase {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy openHelper$delegate = LazyKt.lazy((Function0)openHelper.2.INSTANCE);
    private static final String TABLE_NAME = "logs";
    private static final String COL_ID = "id";
    private static final String COL_FILE = "file";
    private static final String COL_CODE = "code";
    private static final String COL_CONT_CODE = "contCode";
    private static final String COL_TIMESTAMP = "dateFormatter";
    @Deprecated
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LogDatabase.class), "openHelper", "getOpenHelper()Lapp/raybritton/elog/data/LogDatabase$LogDbOpenHelper;"))};
        Companion = new Companion(null);
    }

    private final LogDbOpenHelper getOpenHelper() {
        Lazy lazy = this.openHelper$delegate;
        LogDatabase logDatabase = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (LogDbOpenHelper)((Object)lazy.getValue());
    }

    @NotNull
    public final List<LogFile> getLogs$lib_release() {
        Cursor cursor = this.getOpenHelper().getReadableDatabase().rawQuery("SELECT * FROM logs", new String[0]);
        boolean bl = false;
        List results = new ArrayList();
        while (cursor.moveToNext()) {
            Cursor cursor2 = cursor;
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
            results.add(this.toLogFile(cursor2));
        }
        cursor.close();
        return results;
    }

    public final void insertLog$lib_release(@NotNull LogFile logFile) {
        Intrinsics.checkParameterIsNotNull((Object)logFile, (String)"logFile");
        this.getOpenHelper().getWritableDatabase().insert(TABLE_NAME, null, this.toContentValues(logFile));
    }

    public final void updateLog$lib_release(@NotNull LogFile logFile) {
        Intrinsics.checkParameterIsNotNull((Object)logFile, (String)"logFile");
        this.getOpenHelper().getWritableDatabase().update(TABLE_NAME, this.toContentValues(logFile), "id = ?", new String[]{logFile.getId()});
    }

    public final void deleteLog$lib_release(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)COL_ID);
        this.getOpenHelper().getWritableDatabase().delete(TABLE_NAME, "id = ?", new String[]{id});
    }

    public final void deleteAll$lib_release() {
        this.getOpenHelper().getWritableDatabase().execSQL("DELETE FROM logs");
    }

    @Nullable
    public final LogFile getLatestLog() {
        Cursor cursor = this.getOpenHelper().getReadableDatabase().rawQuery("SELECT * FROM logs ORDER BY dateFormatter DESC LIMIT 1", new String[0]);
        boolean bl = false;
        List results = new ArrayList();
        Cursor cursor2 = cursor;
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
        if (cursor2.getCount() == 0) {
            return null;
        }
        while (cursor.moveToNext()) {
            results.add(this.toLogFile(cursor));
        }
        cursor.close();
        return (LogFile)results.get(0);
    }

    private final ContentValues toContentValues(@NotNull LogFile $this$toContentValues) {
        ContentValues values = new ContentValues();
        values.put(COL_ID, $this$toContentValues.getId());
        values.put(COL_FILE, $this$toContentValues.getFile().getAbsolutePath());
        values.put(COL_TIMESTAMP, Long.valueOf($this$toContentValues.getCreated()));
        values.put(COL_CODE, $this$toContentValues.getCode());
        values.put(COL_CONT_CODE, $this$toContentValues.getContinuationCode());
        return values;
    }

    private final LogFile toLogFile(@NotNull Cursor $this$toLogFile) {
        String string = $this$toLogFile.getString($this$toLogFile.getColumnIndex(COL_ID));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getString(getColumnIndex(COL_ID))");
        return new LogFile(string, new File($this$toLogFile.getString($this$toLogFile.getColumnIndex(COL_FILE))), $this$toLogFile.getLong($this$toLogFile.getColumnIndex(COL_TIMESTAMP)), $this$toLogFile.getString($this$toLogFile.getColumnIndex(COL_CODE)), $this$toLogFile.getString($this$toLogFile.getColumnIndex(COL_CONT_CODE)));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lapp/raybritton/elog/data/LogDatabase$LogDbOpenHelper;", "Landroid/database/sqlite/SQLiteOpenHelper;", "ctx", "Landroid/content/Context;", "name", "", "version", "", "(Landroid/content/Context;Ljava/lang/String;I)V", "onCreate", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "onUpgrade", "oldVer", "newVer", "lib_release"})
    private static final class LogDbOpenHelper
    extends SQLiteOpenHelper {
        public void onCreate(@NotNull SQLiteDatabase db) {
            Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
            db.execSQL("CREATE TABLE logs (id TEXT PRIMARY KEY, file TEXT, code TEXT, dateFormatter INTEGER, contCode TEXT)");
        }

        public void onUpgrade(@NotNull SQLiteDatabase db, int oldVer, int newVer) {
            Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
            if (oldVer == 1 && newVer == 2) {
                db.execSQL("ALTER TABLE logs ADD COLUMN contCode TEXT");
            }
        }

        public LogDbOpenHelper(@NotNull Context ctx, @NotNull String name, int version) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            super(ctx, name, null, version);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lapp/raybritton/elog/data/LogDatabase$Companion;", "", "()V", "COL_CODE", "", "COL_CONT_CODE", "COL_FILE", "COL_ID", "COL_TIMESTAMP", "TABLE_NAME", "lib_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

