package app.raybritton.elog.data

import android.content.Context
import android.os.Build
import app.raybritton.elog.BuildConfig
import app.raybritton.elog.arch.LogModule
import java.util.*

internal object LogPreferences {
    private const val PREF_DEVICE_ID = "device_id.str"

    private val prefs by lazy {
        LogModule.context.getSharedPreferences("elog.prefs", Context.MODE_PRIVATE)
    }

    internal var deviceId: String
        set(value) {
            prefs.edit().putString(PREF_DEVICE_ID, value).apply()
        }
        get() {
            var token = prefs.getString(PREF_DEVICE_ID, "")

            if (token.isNullOrEmpty()) {
                token = Build.MANUFACTURER + "_" + Build.MODEL + "_" + UUID.randomUUID().toString()
                prefs.edit().putString(PREF_DEVICE_ID, token).apply()
            }

            return token
        }
}