/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.antlr.stringtemplate.StringTemplateWriter;

public class AutoIndentWriter
implements StringTemplateWriter {
    public static final int BUFFER_SIZE = 50;
    protected Stack indents = new Stack();
    protected Writer out = null;
    protected boolean atStartOfLine = true;

    public AutoIndentWriter(Writer writer) {
        this.out = writer;
        this.indents.push(null);
    }

    public void pushIndentation(String string) {
        this.indents.push(string);
    }

    public String popIndentation() {
        return (String)this.indents.pop();
    }

    public int write(String string) throws IOException {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                this.atStartOfLine = true;
            } else if (this.atStartOfLine) {
                n += this.indent();
                this.atStartOfLine = false;
            }
            ++n;
            this.out.write(c);
        }
        return n;
    }

    public int indent() throws IOException {
        int n = 0;
        for (int i = 0; i < this.indents.size(); ++i) {
            String string = (String)this.indents.get(i);
            if (string == null) continue;
            n += string.length();
            this.out.write(string);
        }
        return n;
    }
}

