/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.work.Clock;
import androidx.work.Logger;
import androidx.work.impl.background.systemalarm.CommandHandler;
import androidx.work.impl.background.systemalarm.ConstraintProxy;
import androidx.work.impl.background.systemalarm.SystemAlarmDispatcher;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.constraints.trackers.Trackers;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecKt;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class ConstraintsCommandHandler {
    private static final String TAG = Logger.tagWithPrefix("ConstraintsCmdHandler");
    private final Context mContext;
    private final Clock mClock;
    private final int mStartId;
    private final SystemAlarmDispatcher mDispatcher;
    private final WorkConstraintsTracker mWorkConstraintsTracker;

    ConstraintsCommandHandler(@NonNull Context context, Clock clock, int startId, @NonNull SystemAlarmDispatcher dispatcher) {
        this.mContext = context;
        this.mClock = clock;
        this.mStartId = startId;
        this.mDispatcher = dispatcher;
        Trackers trackers = this.mDispatcher.getWorkManager().getTrackers();
        this.mWorkConstraintsTracker = new WorkConstraintsTracker(trackers);
    }

    @WorkerThread
    void handleConstraintsChanged() {
        List<WorkSpec> candidates = this.mDispatcher.getWorkManager().getWorkDatabase().workSpecDao().getScheduledWork();
        ConstraintProxy.updateAll(this.mContext, candidates);
        ArrayList<WorkSpec> eligibleWorkSpecs = new ArrayList<WorkSpec>(candidates.size());
        long now = this.mClock.currentTimeMillis();
        for (WorkSpec workSpec : candidates) {
            long triggerAt = workSpec.calculateNextRunTime();
            if (now < triggerAt || workSpec.hasConstraints() && !this.mWorkConstraintsTracker.areAllConstraintsMet(workSpec)) continue;
            eligibleWorkSpecs.add(workSpec);
        }
        for (WorkSpec workSpec : eligibleWorkSpecs) {
            String workSpecId = workSpec.id;
            Intent intent = CommandHandler.createDelayMetIntent(this.mContext, WorkSpecKt.generationalId(workSpec));
            Logger.get().debug(TAG, "Creating a delay_met command for workSpec with id (" + workSpecId + ")");
            this.mDispatcher.getTaskExecutor().getMainThreadExecutor().execute(new SystemAlarmDispatcher.AddRunnable(this.mDispatcher, intent, this.mStartId));
        }
    }
}

