/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.os.Build;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.impl.Scheduler;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.workers.ConstraintTrackingWorker;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\n\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a8\u0006\u000b"}, d2={"tryDelegateConstrainedWorkSpec", "Landroidx/work/impl/model/WorkSpec;", "workSpec", "usesScheduler", "", "schedulers", "", "Landroidx/work/impl/Scheduler;", "className", "", "wrapInConstraintTrackingWorkerIfNeeded", "work-runtime_release"})
public final class EnqueueUtilsKt {
    @NotNull
    public static final WorkSpec tryDelegateConstrainedWorkSpec(@NotNull WorkSpec workSpec) {
        Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
        Constraints constraints = workSpec.constraints;
        String workerClassName = workSpec.workerClassName;
        boolean isConstraintTrackingWorker = Intrinsics.areEqual((Object)workerClassName, (Object)ConstraintTrackingWorker.class.getName());
        if (!isConstraintTrackingWorker && (constraints.requiresBatteryNotLow() || constraints.requiresStorageNotLow())) {
            Data data = new Data.Builder().putAll(workSpec.input).putString("androidx.work.impl.workers.ConstraintTrackingWorker.ARGUMENT_CLASS_NAME", workerClassName).build();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder().putAll(workSpe\u2026ame)\n            .build()");
            Data newInputData = data;
            String string = ConstraintTrackingWorker.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            return WorkSpec.copy$default(workSpec, null, null, string, null, newInputData, null, 0L, 0L, 0L, null, 0, null, 0L, 0L, 0L, 0L, false, null, 0, 0, 1048555, null);
        }
        return workSpec;
    }

    @NotNull
    public static final WorkSpec wrapInConstraintTrackingWorkerIfNeeded(@NotNull List<? extends Scheduler> schedulers, @NotNull WorkSpec workSpec) {
        Intrinsics.checkNotNullParameter(schedulers, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
        int n = Build.VERSION.SDK_INT;
        return (23 <= n ? n < 26 : false) ? EnqueueUtilsKt.tryDelegateConstrainedWorkSpec(workSpec) : (Build.VERSION.SDK_INT <= 22 && EnqueueUtilsKt.usesScheduler(schedulers, "androidx.work.impl.background.gcm.GcmScheduler") ? EnqueueUtilsKt.tryDelegateConstrainedWorkSpec(workSpec) : workSpec);
    }

    private static final boolean usesScheduler(List<? extends Scheduler> schedulers, String className) {
        try {
            boolean bl;
            block5: {
                Class<?> klass = Class.forName(className);
                Iterable $this$any$iv = schedulers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Scheduler scheduler = (Scheduler)element$iv;
                        boolean bl2 = false;
                        if (!klass.isAssignableFrom(scheduler.getClass())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

