/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.diagnostics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.impl.workers.DiagnosticsWorker;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DiagnosticsReceiver
extends BroadcastReceiver {
    private static final String TAG = Logger.tagWithPrefix("DiagnosticsRcvr");

    public void onReceive(@NonNull Context context, @Nullable Intent intent) {
        if (intent == null) {
            return;
        }
        Logger.get().debug(TAG, "Requesting diagnostics");
        try {
            WorkManager workManager = WorkManager.getInstance(context);
            workManager.enqueue(OneTimeWorkRequest.from(DiagnosticsWorker.class));
        }
        catch (IllegalStateException exception) {
            Logger.get().error(TAG, "WorkManager is not initialized", exception);
        }
    }
}

