/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/work/lint/PeriodicEnqueueIssueDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "work-runtime-lint"})
public final class PeriodicEnqueueIssueDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ISSUE;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"enqueue");
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (context.getEvaluator().isMemberInClass((PsiMember)method, "androidx.work.WorkManager")) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = node.getValueArguments();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String type;
                UExpression argument = (UExpression)element$iv$iv;
                boolean bl = false;
                PsiType psiType = argument.getExpressionType();
                String string = type = psiType != null ? psiType.getCanonicalText() : null;
                boolean bl2 = Intrinsics.areEqual((Object)type, (Object)"androidx.work.PeriodicWorkRequest") || Intrinsics.areEqual((Object)type, (Object)"java.util.List<? extends androidx.work.PeriodicWorkRequest>") || Intrinsics.areEqual((Object)type, (Object)"java.util.List<? extends androidx.work.WorkRequest>");
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List periodic = (List)destination$iv$iv;
            if (!((Collection)periodic).isEmpty()) {
                Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation((PsiElement)method), (String)"Use `enqueueUniquePeriodicWork()` instead of `enqueue()`", null, (int)8, null);
            }
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(PeriodicEnqueueIssueDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"BadPeriodicWorkRequestEnqueue", (String)"Use `enqueueUniquePeriodicWork()` instead of `enqueue()`", (String)"\n                When using `enqueue()` for `PeriodicWorkRequest`s, you might end up enqueuing\n                duplicate requests unintentionally. You should be using\n                `enqueueUniquePeriodicWork` with an `ExistingPeriodicWorkPolicy.KEEP` instead.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/work/lint/PeriodicEnqueueIssueDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "work-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

