/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import androidx.work.Data;
import androidx.work.InputMerger;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001e\u0010\f\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Landroidx/work/ArrayCreatingInputMerger;", "Landroidx/work/InputMerger;", "()V", "concatenateArrayAndNonArray", "", "array", "obj", "valueClass", "Ljava/lang/Class;", "concatenateArrays", "array1", "array2", "createArrayFor", "merge", "Landroidx/work/Data;", "inputs", "", "work-runtime_release"})
public final class ArrayCreatingInputMerger
extends InputMerger {
    @Override
    @NotNull
    public Data merge(@NotNull List<Data> inputs) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Data.Builder output = new Data.Builder();
        Map mergedValues = new HashMap();
        for (Data input : inputs) {
            Map<String, Object> map = input.getKeyValueMap();
            Intrinsics.checkNotNullExpressionValue(map, (String)"input.keyValueMap");
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object object;
                Object value;
                String key = entry.getKey();
                Object object2 = value = entry.getValue();
                Class<Object> clazz = object2 == null ? null : object2.getClass();
                if (clazz == null) {
                    clazz = String.class;
                }
                Class<?> valueClass = clazz;
                Object existingValue = mergedValues.get(key);
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                if (existingValue == null) {
                    object = valueClass.isArray() ? value : this.createArrayFor(value, valueClass);
                } else {
                    Class<?> existingValueClass = existingValue.getClass();
                    if (Intrinsics.areEqual(existingValueClass, valueClass)) {
                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                        object = this.concatenateArrays(existingValue, value);
                    } else if (Intrinsics.areEqual(existingValueClass.getComponentType(), valueClass)) {
                        object = this.concatenateArrayAndNonArray(existingValue, value, valueClass);
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                Object object3 = object;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"if (existingValue == nul\u2026      }\n                }");
                mergedValues.put(key, object3);
            }
        }
        output.putAll(mergedValues);
        Data data = output.build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"output.build()");
        return data;
    }

    private final Object concatenateArrays(Object array1, Object array2) {
        int length1 = Array.getLength(array1);
        int length2 = Array.getLength(array2);
        Class<?> clazz = array1.getClass().getComponentType();
        Intrinsics.checkNotNull(clazz);
        Object newArray = Array.newInstance(clazz, length1 + length2);
        System.arraycopy(array1, 0, newArray, 0, length1);
        System.arraycopy(array2, 0, newArray, length1, length2);
        Intrinsics.checkNotNullExpressionValue((Object)newArray, (String)"newArray");
        return newArray;
    }

    private final Object concatenateArrayAndNonArray(Object array, Object obj, Class<?> valueClass) {
        int arrayLength = Array.getLength(array);
        Object newArray = Array.newInstance(valueClass, arrayLength + 1);
        System.arraycopy(array, 0, newArray, 0, arrayLength);
        Array.set(newArray, arrayLength, obj);
        Intrinsics.checkNotNullExpressionValue((Object)newArray, (String)"newArray");
        return newArray;
    }

    private final Object createArrayFor(Object obj, Class<?> valueClass) {
        Object newArray = Array.newInstance(valueClass, 1);
        Array.set(newArray, 0, obj);
        Intrinsics.checkNotNullExpressionValue((Object)newArray, (String)"newArray");
        return newArray;
    }
}

