/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.model.Preference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class IdGenerator {
    public static final int INITIAL_ID = 0;
    public static final String PREFERENCE_FILE_KEY = "androidx.work.util.id";
    public static final String NEXT_JOB_SCHEDULER_ID_KEY = "next_job_scheduler_id";
    public static final String NEXT_ALARM_MANAGER_ID_KEY = "next_alarm_manager_id";
    private final WorkDatabase mWorkDatabase;

    public IdGenerator(@NonNull WorkDatabase workDatabase) {
        this.mWorkDatabase = workDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextJobSchedulerIdWithRange(int minInclusive, int maxInclusive) {
        Class<IdGenerator> clazz = IdGenerator.class;
        synchronized (IdGenerator.class) {
            int id = this.nextId(NEXT_JOB_SCHEDULER_ID_KEY);
            if (id < minInclusive || id > maxInclusive) {
                id = minInclusive;
                this.update(NEXT_JOB_SCHEDULER_ID_KEY, id + 1);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextAlarmManagerId() {
        Class<IdGenerator> clazz = IdGenerator.class;
        synchronized (IdGenerator.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nextId(NEXT_ALARM_MANAGER_ID_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextId(String key) {
        this.mWorkDatabase.beginTransaction();
        try {
            Long value = this.mWorkDatabase.preferenceDao().getLongValue(key);
            int id = value != null ? value.intValue() : 0;
            int nextId = id == Integer.MAX_VALUE ? 0 : id + 1;
            this.update(key, nextId);
            this.mWorkDatabase.setTransactionSuccessful();
            int n = id;
            return n;
        }
        finally {
            this.mWorkDatabase.endTransaction();
        }
    }

    private void update(String key, int value) {
        this.mWorkDatabase.preferenceDao().insertPreference(new Preference(key, Long.valueOf(value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateLegacyIdGenerator(@NonNull Context context, @NonNull SupportSQLiteDatabase sqLiteDatabase) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFERENCE_FILE_KEY, 0);
        if (sharedPreferences.contains(NEXT_JOB_SCHEDULER_ID_KEY) || sharedPreferences.contains(NEXT_JOB_SCHEDULER_ID_KEY)) {
            int nextJobId = sharedPreferences.getInt(NEXT_JOB_SCHEDULER_ID_KEY, 0);
            int nextAlarmId = sharedPreferences.getInt(NEXT_ALARM_MANAGER_ID_KEY, 0);
            sqLiteDatabase.beginTransaction();
            try {
                sqLiteDatabase.execSQL("INSERT OR REPLACE INTO `Preference` (`key`, `long_value`) VALUES (@key, @long_value)", new Object[]{NEXT_JOB_SCHEDULER_ID_KEY, nextJobId});
                sqLiteDatabase.execSQL("INSERT OR REPLACE INTO `Preference` (`key`, `long_value`) VALUES (@key, @long_value)", new Object[]{NEXT_ALARM_MANAGER_ID_KEY, nextAlarmId});
                sharedPreferences.edit().clear().apply();
                sqLiteDatabase.setTransactionSuccessful();
            }
            finally {
                sqLiteDatabase.endTransaction();
            }
        }
    }
}

