/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.controllers;

import androidx.work.impl.constraints.ConstraintListener;
import androidx.work.impl.constraints.trackers.ConstraintTracker;
import androidx.work.impl.model.WorkSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001$B\u0015\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0011J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u001e\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 J\u0006\u0010!\u001a\u00020\u001bJ!\u0010\"\u001a\u00020\u001b2\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010#R(\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/work/impl/constraints/controllers/ConstraintController;", "T", "Landroidx/work/impl/constraints/ConstraintListener;", "tracker", "Landroidx/work/impl/constraints/trackers/ConstraintTracker;", "(Landroidx/work/impl/constraints/trackers/ConstraintTracker;)V", "value", "Landroidx/work/impl/constraints/controllers/ConstraintController$OnConstraintUpdatedCallback;", "callback", "getCallback", "()Landroidx/work/impl/constraints/controllers/ConstraintController$OnConstraintUpdatedCallback;", "setCallback", "(Landroidx/work/impl/constraints/controllers/ConstraintController$OnConstraintUpdatedCallback;)V", "currentValue", "Ljava/lang/Object;", "matchingWorkSpecIds", "", "", "hasConstraint", "", "workSpec", "Landroidx/work/impl/model/WorkSpec;", "isConstrained", "(Ljava/lang/Object;)Z", "isWorkSpecConstrained", "workSpecId", "onConstraintChanged", "", "newValue", "(Ljava/lang/Object;)V", "replace", "workSpecs", "", "reset", "updateCallback", "(Landroidx/work/impl/constraints/controllers/ConstraintController$OnConstraintUpdatedCallback;Ljava/lang/Object;)V", "OnConstraintUpdatedCallback", "work-runtime_release"})
public abstract class ConstraintController<T>
implements ConstraintListener<T> {
    @NotNull
    private final ConstraintTracker<T> tracker;
    @NotNull
    private final List<String> matchingWorkSpecIds;
    @Nullable
    private T currentValue;
    @Nullable
    private OnConstraintUpdatedCallback callback;

    public ConstraintController(@NotNull ConstraintTracker<T> tracker) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        this.tracker = tracker;
        this.matchingWorkSpecIds = new ArrayList();
    }

    @Nullable
    public final OnConstraintUpdatedCallback getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable OnConstraintUpdatedCallback value) {
        if (this.callback != value) {
            this.callback = value;
            this.updateCallback(value, this.currentValue);
        }
    }

    public abstract boolean hasConstraint(@NotNull WorkSpec var1);

    public abstract boolean isConstrained(T var1);

    /*
     * WARNING - void declaration
     */
    public final void replace(@NotNull Iterable<WorkSpec> workSpecs) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(workSpecs, (String)"workSpecs");
        this.matchingWorkSpecIds.clear();
        Iterable<WorkSpec> iterable = workSpecs;
        Collection destination$iv = this.matchingWorkSpecIds;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            WorkSpec it = (WorkSpec)element$iv;
            boolean bl2 = false;
            if ((this.hasConstraint(it) ? it.id : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        if (this.matchingWorkSpecIds.isEmpty()) {
            this.tracker.removeListener(this);
        } else {
            this.tracker.addListener(this);
        }
        this.updateCallback(this.callback, this.currentValue);
    }

    public final void reset() {
        if (!((Collection)this.matchingWorkSpecIds).isEmpty()) {
            this.matchingWorkSpecIds.clear();
            this.tracker.removeListener(this);
        }
    }

    public final boolean isWorkSpecConstrained(@NotNull String workSpecId) {
        Intrinsics.checkNotNullParameter((Object)workSpecId, (String)"workSpecId");
        T value = this.currentValue;
        return value != null && this.isConstrained(value) && this.matchingWorkSpecIds.contains(workSpecId);
    }

    private final void updateCallback(OnConstraintUpdatedCallback callback, T currentValue) {
        if (this.matchingWorkSpecIds.isEmpty() || callback == null) {
            return;
        }
        if (currentValue == null || this.isConstrained(currentValue)) {
            callback.onConstraintNotMet(this.matchingWorkSpecIds);
        } else {
            callback.onConstraintMet(this.matchingWorkSpecIds);
        }
    }

    @Override
    public void onConstraintChanged(T newValue) {
        this.currentValue = newValue;
        this.updateCallback(this.callback, this.currentValue);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\u0016\u0010\u0007\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\b"}, d2={"Landroidx/work/impl/constraints/controllers/ConstraintController$OnConstraintUpdatedCallback;", "", "onConstraintMet", "", "workSpecIds", "", "", "onConstraintNotMet", "work-runtime_release"})
    public static interface OnConstraintUpdatedCallback {
        public void onConstraintMet(@NotNull List<String> var1);

        public void onConstraintNotMet(@NotNull List<String> var1);
    }
}

