/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.TypeConverters;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import androidx.work.Data;
import androidx.work.impl.WorkDatabaseMigrations;
import androidx.work.impl.WorkDatabasePathHelper;
import androidx.work.impl.model.Dependency;
import androidx.work.impl.model.DependencyDao;
import androidx.work.impl.model.Preference;
import androidx.work.impl.model.PreferenceDao;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.SystemIdInfoDao;
import androidx.work.impl.model.WorkName;
import androidx.work.impl.model.WorkNameDao;
import androidx.work.impl.model.WorkProgress;
import androidx.work.impl.model.WorkProgressDao;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkTag;
import androidx.work.impl.model.WorkTagDao;
import androidx.work.impl.model.WorkTypeConverters;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Database(entities={Dependency.class, WorkSpec.class, WorkTag.class, SystemIdInfo.class, WorkName.class, WorkProgress.class, Preference.class}, version=10)
@TypeConverters(value={Data.class, WorkTypeConverters.class})
public abstract class WorkDatabase
extends RoomDatabase {
    private static final String PRUNE_SQL_FORMAT_PREFIX = "DELETE FROM workspec WHERE state IN (2, 3, 5) AND (period_start_time + minimum_retention_duration) < ";
    private static final String PRUNE_SQL_FORMAT_SUFFIX = " AND (SELECT COUNT(*)=0 FROM dependency WHERE     prerequisite_id=id AND     work_spec_id NOT IN         (SELECT id FROM workspec WHERE state IN (2, 3, 5)))";
    private static final long PRUNE_THRESHOLD_MILLIS = TimeUnit.DAYS.toMillis(7L);

    @NonNull
    public static WorkDatabase create(final @NonNull Context context, @NonNull Executor queryExecutor, boolean useTestDatabase) {
        RoomDatabase.Builder builder;
        if (useTestDatabase) {
            builder = Room.inMemoryDatabaseBuilder((Context)context, WorkDatabase.class).allowMainThreadQueries();
        } else {
            String name = WorkDatabasePathHelper.getWorkDatabaseName();
            builder = Room.databaseBuilder((Context)context, WorkDatabase.class, (String)name);
            builder.openHelperFactory(new SupportSQLiteOpenHelper.Factory(){

                @NonNull
                public SupportSQLiteOpenHelper create(@NonNull SupportSQLiteOpenHelper.Configuration configuration) {
                    SupportSQLiteOpenHelper.Configuration.Builder configBuilder = SupportSQLiteOpenHelper.Configuration.builder((Context)context);
                    configBuilder.name(configuration.name).callback(configuration.callback).noBackupDirectory(true);
                    FrameworkSQLiteOpenHelperFactory factory = new FrameworkSQLiteOpenHelperFactory();
                    return factory.create(configBuilder.build());
                }
            });
        }
        return (WorkDatabase)builder.setQueryExecutor(queryExecutor).addCallback(WorkDatabase.generateCleanupCallback()).addMigrations(new Migration[]{WorkDatabaseMigrations.MIGRATION_1_2}).addMigrations(new Migration[]{new WorkDatabaseMigrations.RescheduleMigration(context, 2, 3)}).addMigrations(new Migration[]{WorkDatabaseMigrations.MIGRATION_3_4}).addMigrations(new Migration[]{WorkDatabaseMigrations.MIGRATION_4_5}).addMigrations(new Migration[]{new WorkDatabaseMigrations.RescheduleMigration(context, 5, 6)}).addMigrations(new Migration[]{WorkDatabaseMigrations.MIGRATION_6_7}).addMigrations(new Migration[]{WorkDatabaseMigrations.MIGRATION_7_8}).addMigrations(new Migration[]{WorkDatabaseMigrations.MIGRATION_8_9}).addMigrations(new Migration[]{new WorkDatabaseMigrations.WorkMigration9To10(context)}).fallbackToDestructiveMigration().build();
    }

    static RoomDatabase.Callback generateCleanupCallback() {
        return new RoomDatabase.Callback(){

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                super.onOpen(db);
                db.beginTransaction();
                try {
                    db.execSQL(WorkDatabase.getPruneSQL());
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
        };
    }

    @NonNull
    static String getPruneSQL() {
        return PRUNE_SQL_FORMAT_PREFIX + WorkDatabase.getPruneDate() + PRUNE_SQL_FORMAT_SUFFIX;
    }

    static long getPruneDate() {
        return System.currentTimeMillis() - PRUNE_THRESHOLD_MILLIS;
    }

    @NonNull
    public abstract WorkSpecDao workSpecDao();

    @NonNull
    public abstract DependencyDao dependencyDao();

    @NonNull
    public abstract WorkTagDao workTagDao();

    @NonNull
    public abstract SystemIdInfoDao systemIdInfoDao();

    @NonNull
    public abstract WorkNameDao workNameDao();

    @NonNull
    public abstract WorkProgressDao workProgressDao();

    @NonNull
    public abstract PreferenceDao preferenceDao();
}

