/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.trackers;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.impl.constraints.trackers.BroadcastReceiverConstraintTracker;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class BatteryChargingTracker
extends BroadcastReceiverConstraintTracker<Boolean> {
    private static final String TAG = Logger.tagWithPrefix("BatteryChrgTracker");

    public BatteryChargingTracker(@NonNull Context context, @NonNull TaskExecutor taskExecutor) {
        super(context, taskExecutor);
    }

    @Override
    public Boolean getInitialState() {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = this.mAppContext.registerReceiver(null, intentFilter);
        if (intent == null) {
            Logger.get().error(TAG, "getInitialState - null intent received", new Throwable[0]);
            return null;
        }
        return this.isBatteryChangedIntentCharging(intent);
    }

    @Override
    public IntentFilter getIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        if (Build.VERSION.SDK_INT >= 23) {
            intentFilter.addAction("android.os.action.CHARGING");
            intentFilter.addAction("android.os.action.DISCHARGING");
        } else {
            intentFilter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
            intentFilter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
        }
        return intentFilter;
    }

    @Override
    public void onBroadcastReceive(Context context, @NonNull Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        Logger.get().debug(TAG, String.format("Received %s", action), new Throwable[0]);
        switch (action) {
            case "android.os.action.CHARGING": {
                this.setState(true);
                break;
            }
            case "android.os.action.DISCHARGING": {
                this.setState(false);
                break;
            }
            case "android.intent.action.ACTION_POWER_CONNECTED": {
                this.setState(true);
                break;
            }
            case "android.intent.action.ACTION_POWER_DISCONNECTED": {
                this.setState(false);
            }
        }
    }

    private boolean isBatteryChangedIntentCharging(Intent intent) {
        int chargePlug;
        int status;
        boolean charging = Build.VERSION.SDK_INT >= 23 ? (status = intent.getIntExtra("status", -1)) == 2 || status == 5 : (chargePlug = intent.getIntExtra("plugged", 0)) != 0;
        return charging;
    }
}

