/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.arch.core.util.Function;
import androidx.room.ColumnInfo;
import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.Relation;
import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.impl.model.WorkProgress;
import androidx.work.impl.model.WorkTag;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Entity(indices={@Index(value={"schedule_requested_at"})})
public class WorkSpec {
    private static final String TAG = Logger.tagWithPrefix("WorkSpec");
    public static final long SCHEDULE_NOT_REQUESTED_YET = -1L;
    @ColumnInfo(name="id")
    @PrimaryKey
    @NonNull
    public String id;
    @ColumnInfo(name="state")
    @NonNull
    public WorkInfo.State state = WorkInfo.State.ENQUEUED;
    @ColumnInfo(name="worker_class_name")
    @NonNull
    public String workerClassName;
    @ColumnInfo(name="input_merger_class_name")
    public String inputMergerClassName;
    @ColumnInfo(name="input")
    @NonNull
    public Data input = Data.EMPTY;
    @ColumnInfo(name="output")
    @NonNull
    public Data output = Data.EMPTY;
    @ColumnInfo(name="initial_delay")
    public long initialDelay;
    @ColumnInfo(name="interval_duration")
    public long intervalDuration;
    @ColumnInfo(name="flex_duration")
    public long flexDuration;
    @Embedded
    @NonNull
    public Constraints constraints = Constraints.NONE;
    @ColumnInfo(name="run_attempt_count")
    @IntRange(from=0L)
    public int runAttemptCount;
    @ColumnInfo(name="backoff_policy")
    @NonNull
    public BackoffPolicy backoffPolicy = BackoffPolicy.EXPONENTIAL;
    @ColumnInfo(name="backoff_delay_duration")
    public long backoffDelayDuration = 30000L;
    @ColumnInfo(name="period_start_time")
    public long periodStartTime;
    @ColumnInfo(name="minimum_retention_duration")
    public long minimumRetentionDuration;
    @ColumnInfo(name="schedule_requested_at")
    public long scheduleRequestedAt = -1L;
    public static final Function<List<WorkInfoPojo>, List<WorkInfo>> WORK_INFO_MAPPER = new Function<List<WorkInfoPojo>, List<WorkInfo>>(){

        public List<WorkInfo> apply(List<WorkInfoPojo> input) {
            if (input == null) {
                return null;
            }
            ArrayList<WorkInfo> output = new ArrayList<WorkInfo>(input.size());
            for (WorkInfoPojo in : input) {
                output.add(in.toWorkInfo());
            }
            return output;
        }
    };

    public WorkSpec(@NonNull String id, @NonNull String workerClassName) {
        this.id = id;
        this.workerClassName = workerClassName;
    }

    public WorkSpec(@NonNull WorkSpec other) {
        this.id = other.id;
        this.workerClassName = other.workerClassName;
        this.state = other.state;
        this.inputMergerClassName = other.inputMergerClassName;
        this.input = new Data(other.input);
        this.output = new Data(other.output);
        this.initialDelay = other.initialDelay;
        this.intervalDuration = other.intervalDuration;
        this.flexDuration = other.flexDuration;
        this.constraints = new Constraints(other.constraints);
        this.runAttemptCount = other.runAttemptCount;
        this.backoffPolicy = other.backoffPolicy;
        this.backoffDelayDuration = other.backoffDelayDuration;
        this.periodStartTime = other.periodStartTime;
        this.minimumRetentionDuration = other.minimumRetentionDuration;
        this.scheduleRequestedAt = other.scheduleRequestedAt;
    }

    public void setBackoffDelayDuration(long backoffDelayDuration) {
        if (backoffDelayDuration > 18000000L) {
            Logger.get().warning(TAG, "Backoff delay duration exceeds maximum value", new Throwable[0]);
            backoffDelayDuration = 18000000L;
        }
        if (backoffDelayDuration < 10000L) {
            Logger.get().warning(TAG, "Backoff delay duration less than minimum value", new Throwable[0]);
            backoffDelayDuration = 10000L;
        }
        this.backoffDelayDuration = backoffDelayDuration;
    }

    public boolean isPeriodic() {
        return this.intervalDuration != 0L;
    }

    public boolean isBackedOff() {
        return this.state == WorkInfo.State.ENQUEUED && this.runAttemptCount > 0;
    }

    public void setPeriodic(long intervalDuration) {
        if (intervalDuration < 900000L) {
            Logger.get().warning(TAG, String.format("Interval duration lesser than minimum allowed value; Changed to %s", 900000L), new Throwable[0]);
            intervalDuration = 900000L;
        }
        this.setPeriodic(intervalDuration, intervalDuration);
    }

    public void setPeriodic(long intervalDuration, long flexDuration) {
        if (intervalDuration < 900000L) {
            Logger.get().warning(TAG, String.format("Interval duration lesser than minimum allowed value; Changed to %s", 900000L), new Throwable[0]);
            intervalDuration = 900000L;
        }
        if (flexDuration < 300000L) {
            Logger.get().warning(TAG, String.format("Flex duration lesser than minimum allowed value; Changed to %s", 300000L), new Throwable[0]);
            flexDuration = 300000L;
        }
        if (flexDuration > intervalDuration) {
            Logger.get().warning(TAG, String.format("Flex duration greater than interval duration; Changed to %s", intervalDuration), new Throwable[0]);
            flexDuration = intervalDuration;
        }
        this.intervalDuration = intervalDuration;
        this.flexDuration = flexDuration;
    }

    public long calculateNextRunTime() {
        if (this.isBackedOff()) {
            boolean isLinearBackoff = this.backoffPolicy == BackoffPolicy.LINEAR;
            long delay = isLinearBackoff ? this.backoffDelayDuration * (long)this.runAttemptCount : (long)Math.scalb(this.backoffDelayDuration, this.runAttemptCount - 1);
            return this.periodStartTime + Math.min(18000000L, delay);
        }
        if (this.isPeriodic()) {
            boolean isFlexApplicable;
            long now = System.currentTimeMillis();
            long start = this.periodStartTime == 0L ? now + this.initialDelay : this.periodStartTime;
            boolean bl = isFlexApplicable = this.flexDuration != this.intervalDuration;
            if (isFlexApplicable) {
                long offset = this.periodStartTime == 0L ? -1L * this.flexDuration : 0L;
                return start + this.intervalDuration + offset;
            }
            long offset = this.periodStartTime == 0L ? 0L : this.intervalDuration;
            return start + offset;
        }
        long start = this.periodStartTime == 0L ? System.currentTimeMillis() : this.periodStartTime;
        return start + this.initialDelay;
    }

    public boolean hasConstraints() {
        return !Constraints.NONE.equals(this.constraints);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkSpec workSpec = (WorkSpec)o;
        if (this.initialDelay != workSpec.initialDelay) {
            return false;
        }
        if (this.intervalDuration != workSpec.intervalDuration) {
            return false;
        }
        if (this.flexDuration != workSpec.flexDuration) {
            return false;
        }
        if (this.runAttemptCount != workSpec.runAttemptCount) {
            return false;
        }
        if (this.backoffDelayDuration != workSpec.backoffDelayDuration) {
            return false;
        }
        if (this.periodStartTime != workSpec.periodStartTime) {
            return false;
        }
        if (this.minimumRetentionDuration != workSpec.minimumRetentionDuration) {
            return false;
        }
        if (this.scheduleRequestedAt != workSpec.scheduleRequestedAt) {
            return false;
        }
        if (!this.id.equals(workSpec.id)) {
            return false;
        }
        if (this.state != workSpec.state) {
            return false;
        }
        if (!this.workerClassName.equals(workSpec.workerClassName)) {
            return false;
        }
        if (this.inputMergerClassName != null ? !this.inputMergerClassName.equals(workSpec.inputMergerClassName) : workSpec.inputMergerClassName != null) {
            return false;
        }
        if (!this.input.equals(workSpec.input)) {
            return false;
        }
        if (!this.output.equals(workSpec.output)) {
            return false;
        }
        if (!this.constraints.equals(workSpec.constraints)) {
            return false;
        }
        return this.backoffPolicy == workSpec.backoffPolicy;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.workerClassName.hashCode();
        result = 31 * result + (this.inputMergerClassName != null ? this.inputMergerClassName.hashCode() : 0);
        result = 31 * result + this.input.hashCode();
        result = 31 * result + this.output.hashCode();
        result = 31 * result + (int)(this.initialDelay ^ this.initialDelay >>> 32);
        result = 31 * result + (int)(this.intervalDuration ^ this.intervalDuration >>> 32);
        result = 31 * result + (int)(this.flexDuration ^ this.flexDuration >>> 32);
        result = 31 * result + this.constraints.hashCode();
        result = 31 * result + this.runAttemptCount;
        result = 31 * result + this.backoffPolicy.hashCode();
        result = 31 * result + (int)(this.backoffDelayDuration ^ this.backoffDelayDuration >>> 32);
        result = 31 * result + (int)(this.periodStartTime ^ this.periodStartTime >>> 32);
        result = 31 * result + (int)(this.minimumRetentionDuration ^ this.minimumRetentionDuration >>> 32);
        result = 31 * result + (int)(this.scheduleRequestedAt ^ this.scheduleRequestedAt >>> 32);
        return result;
    }

    @NonNull
    public String toString() {
        return "{WorkSpec: " + this.id + "}";
    }

    public static class WorkInfoPojo {
        @ColumnInfo(name="id")
        public String id;
        @ColumnInfo(name="state")
        public WorkInfo.State state;
        @ColumnInfo(name="output")
        public Data output;
        @ColumnInfo(name="run_attempt_count")
        public int runAttemptCount;
        @Relation(parentColumn="id", entityColumn="work_spec_id", entity=WorkTag.class, projection={"tag"})
        public List<String> tags;
        @Relation(parentColumn="id", entityColumn="work_spec_id", entity=WorkProgress.class, projection={"progress"})
        public List<Data> progress;

        @NonNull
        public WorkInfo toWorkInfo() {
            Data progress = this.progress != null && !this.progress.isEmpty() ? this.progress.get(0) : Data.EMPTY;
            return new WorkInfo(UUID.fromString(this.id), this.state, this.output, this.tags, progress, this.runAttemptCount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkInfoPojo that = (WorkInfoPojo)o;
            if (this.runAttemptCount != that.runAttemptCount) {
                return false;
            }
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.state != that.state) {
                return false;
            }
            if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
                return false;
            }
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
                return false;
            }
            return this.progress != null ? this.progress.equals(that.progress) : that.progress == null;
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
            result = 31 * result + this.runAttemptCount;
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.progress != null ? this.progress.hashCode() : 0);
            return result;
        }
    }

    public static class IdAndState {
        @ColumnInfo(name="id")
        public String id;
        @ColumnInfo(name="state")
        public WorkInfo.State state;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdAndState that = (IdAndState)o;
            if (this.state != that.state) {
                return false;
            }
            return this.id.equals(that.id);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.state.hashCode();
            return result;
        }
    }
}

